# D&D 5th Edition Combat Rules Reference

## Core Combat Mechanics

This document provides a quick reference for D&D 5th Edition combat rules as implemented in the Tutorial 4 combat system.

## Initiative

Initiative determines the order in which combatants act during a battle.

**Mechanic:**
1. Each combatant rolls d20 + DEX modifier
2. Higher total goes first
3. On tie, higher DEX modifier goes first (or re-roll if still tied)

**Formula:**
```
Initiative = d20 + DEX modifier
```

**Example:**
```
Bob (DEX 12, +1 modifier): rolls 15 + 1 = 16
Goblin (DEX 14, +2 modifier): rolls 11 + 2 = 13

Bob goes first!
```

**Tie-Breaking:**
```
Bob: rolls 15 + 1 = 16
Goblin: rolls 14 + 2 = 16

Tied at 16! Higher DEX (Goblin) goes first.

OR

Re-roll initiative for tied combatants only.
```

## Attack Rolls

Attack rolls determine whether a weapon or spell attack hits the target.

**Mechanic:**
1. Roll d20 + attack bonus
2. Compare total to target's Armor Class (AC)
3. If total ≥ AC: Hit!
4. If total < AC: Miss

**Attack Bonus Formula:**
```
Melee weapon attack = Proficiency bonus + STR modifier
Ranged weapon attack = Proficiency bonus + DEX modifier
Finesse weapon attack = Proficiency bonus + (STR or DEX, your choice)
```

**Example - Melee Attack:**
```
Bob (Level 1, Proficiency +2, STR 16 [+3]) attacks with longsword
Attack bonus: +2 (proficiency) + +3 (STR) = +5

Roll: 13 + 5 = 18
Target AC: 15
18 ≥ 15 → HIT!
```

**Example - Ranged Attack:**
```
Elara (Level 1, Proficiency +2, DEX 16 [+3]) attacks with shortbow
Attack bonus: +2 (proficiency) + +3 (DEX) = +5

Roll: 9 + 5 = 14
Target AC: 15
14 < 15 → MISS!
```

### Critical Hits and Fumbles

**Natural 20 (Critical Hit):**
- Automatically hits regardless of AC
- Roll all damage dice twice, then add modifiers once
- Narrative moment of awesome!

**Example Critical:**
```
Attack roll: Natural 20!
Normal damage: 1d8+3
Critical damage: 2d8+3

Roll: (6)+(4)+3 = 13 damage!
```

**Natural 1 (Critical Miss/Fumble):**
- Automatically misses regardless of attack bonus
- No additional effect in basic 5e rules
- Narrative opportunity for description

## Damage Rolls

After a successful hit, roll damage dice to determine how much harm is dealt.

**Mechanic:**
1. Roll weapon/spell damage dice
2. Add ability modifier (for weapons)
3. Subtract total from target's current HP

**Weapon Damage Formula:**
```
Melee weapon damage = Weapon dice + STR modifier
Ranged weapon damage = Weapon dice + DEX modifier
Finesse weapon damage = Weapon dice + (STR or DEX, your choice)
```

**Example - Longsword Hit:**
```
Bob hits with longsword (1d8 slashing)
STR modifier: +3

Damage roll: 1d8+3 = 6+3 = 9 slashing damage
```

**Example - Critical Hit:**
```
Bob critically hits with longsword
Normal: 1d8+3
Critical: 2d8+3

Damage roll: (1d8)+(1d8)+3 = 5+7+3 = 15 slashing damage!
```

### Damage Types

Different damage types have different narrative descriptions:

- **Slashing**: Swords, axes - cuts and gashes
- **Piercing**: Arrows, spears - punctures and holes
- **Bludgeoning**: Maces, hammers - crushing impacts and broken bones
- **Fire**: Flames and heat - burns and ignition
- **Cold**: Ice and frost - freezing and frostbite
- **Lightning**: Electrical energy - shocks and burns
- **Thunder**: Sound waves - concussive force
- **Force**: Pure magical energy - invisible impact
- **Radiant**: Holy light - searing divine power
- **Necrotic**: Death energy - withering and decay
- **Acid**: Corrosive - melting and burning
- **Poison**: Toxic - sickness and weakening

## Armor Class (AC)

AC represents how difficult it is to land a damaging hit on a creature.

### AC Calculation by Armor Type

**Unarmored:**
```
AC = 10 + DEX modifier
```

**Light Armor** (e.g., leather armor, padded armor):
```
AC = Armor base AC + full DEX modifier
```
- Leather armor: 11 + DEX modifier
- Studded leather: 12 + DEX modifier

**Medium Armor** (e.g., hide, chain shirt):
```
AC = Armor base AC + DEX modifier (max +2)
```
- Hide armor: 12 + DEX (max +2)
- Chain shirt: 13 + DEX (max +2)

**Heavy Armor** (e.g., chain mail, plate):
```
AC = Armor base AC (no DEX modifier)
```
- Chain mail: 16
- Splint: 17
- Plate: 18

**Shield:**
```
+2 AC (stacks with any armor type or unarmored)
```

### AC Examples

**Unarmored Wizard (DEX 16, +3):**
```
AC = 10 + 3 = 13
```

**Rogue in Leather (DEX 18, +4):**
```
AC = 11 (leather) + 4 (DEX) = 15
```

**Fighter in Chain Mail + Shield (DEX 12, +1):**
```
AC = 16 (chain mail, no DEX) + 2 (shield) = 18
```

**Monk Unarmored (DEX 16 [+3], WIS 14 [+2]):**
```
AC = 10 + 3 (DEX) + 2 (WIS, Unarmored Defense feature) = 15
```

## Proficiency Bonus

Proficiency bonus increases as character level increases, representing growing skill and expertise.

**By Character Level:**

| Level | Proficiency Bonus |
|-------|-------------------|
| 1-4   | +2                |
| 5-8   | +3                |
| 9-12  | +4                |
| 13-16 | +5                |
| 17-20 | +6                |

**What Uses Proficiency Bonus:**
- Attack rolls with weapons you're proficient in
- Spell attack rolls
- Saving throws you're proficient in
- Skill checks you're proficient in
- Tool uses you're proficient in

**Example:**
```
Level 1 Fighter attacking with longsword (proficient):
Attack bonus = +2 (proficiency) + +3 (STR) = +5

Level 5 Fighter attacking with longsword (proficient):
Attack bonus = +3 (proficiency) + +3 (STR) = +6
```

## Ability Scores and Modifiers

Ability scores range from 1-20 (higher is better). The modifier is what you actually add to rolls.

**Modifier Calculation:**
```
Modifier = (Ability Score - 10) / 2 (rounded down)
```

**Common Scores and Modifiers:**

| Score | Modifier |
|-------|----------|
| 8-9   | -1       |
| 10-11 | +0       |
| 12-13 | +1       |
| 14-15 | +2       |
| 16-17 | +3       |
| 18-19 | +4       |
| 20    | +5       |

**The Six Abilities:**

- **Strength (STR)**: Physical power, melee attacks, Athletics
- **Dexterity (DEX)**: Agility, AC, ranged attacks, Stealth, Acrobatics
- **Constitution (CON)**: Health, stamina, hit points
- **Intelligence (INT)**: Reasoning, memory, Investigation, wizard spells
- **Wisdom (WIS)**: Awareness, insight, Perception, cleric/druid spells
- **Charisma (CHA)**: Force of personality, Persuasion, sorcerer/warlock spells

## Saving Throws

Saving throws represent a character's ability to resist or avoid certain effects.

**Mechanic:**
1. Roll d20 + ability modifier
2. Add proficiency bonus if proficient in that save
3. Compare to Difficulty Class (DC)
4. If total ≥ DC: Success!
5. If total < DC: Failure

**Saving Throw Formula:**
```
Save = d20 + ability modifier + proficiency (if proficient)
```

**Common Save Types:**
- **DEX saves**: Dodging fireballs, avoiding traps
- **CON saves**: Resisting poison, maintaining concentration
- **WIS saves**: Resisting charm, sensing illusions
- **STR saves**: Breaking free from grapples
- **INT saves**: Resisting psychic attacks
- **CHA saves**: Resisting banishment

**Example - DEX Save vs. Burning Hands:**
```
Goblin (DEX 14, +2 modifier, not proficient in DEX saves)
Wizard's spell save DC: 13

Goblin rolls: 10 + 2 = 12
12 < 13 → FAILED SAVE!

Takes full damage: 3d6 = 11 fire damage

If Goblin had rolled 11 or higher:
Success! Takes half damage: 5 fire damage (11/2 rounded down)
```

## Hit Points (HP)

Hit points represent a character's health and stamina.

**HP Mechanics:**
- Start combat at maximum HP
- Take damage from successful attacks
- When HP reaches 0: defeated (in this tutorial)
- Advanced rules: Death saves, unconsciousness (future tutorials)

**Healing:**
- Spells: Healing Word, Cure Wounds restore HP
- Potions: Restore HP instantly
- Short Rest: Roll hit dice to recover HP
- Long Rest: Restore to full HP

**Example:**
```
Bob starts with 11/11 HP

Takes 5 damage from Goblin scimitar → 6/11 HP
Takes 3 more damage → 3/11 HP
Defeats Goblin → Healed to 11/11 HP (training arena magic)
```

## Turn Structure

Each combatant gets one turn per round of combat.

**On Your Turn (in order):**
1. **Movement**: Up to your speed (30 ft for most characters)
2. **Action**: One main action
   - Attack (weapon or spell)
   - Cast a Spell (if 1 action casting time)
   - Dash (double movement)
   - Dodge (+AC until next turn)
   - Help (give ally advantage)
   - Other actions
3. **Bonus Action**: If you have a feature that uses it
4. **Reaction**: Used on others' turns (e.g., Opportunity Attack, Shield spell)

**Tutorial 4 Simplified Turn:**
- In this tutorial, turns are simplified to: Attack OR Cast Spell OR Flee OR Surrender
- Movement is assumed/narrated but not tracked precisely
- Bonus actions and reactions will be added in future tutorials

## Challenge Rating (CR)

Challenge Rating indicates how dangerous a monster is.

**CR Guidelines:**
- **CR 0**: Trivial for level 1 characters (Rat)
- **CR 1/4**: Easy for level 1 characters (Goblin, Skeleton)
- **CR 1/2**: Moderate for level 1 characters (Orc)
- **CR 1**: Challenging for level 1 characters (Dire Wolf)
- **CR 2+**: Deadly for level 1 characters

**Encounter Building (simplified):**
```
For level 1 character:
- CR 0-1/4: Easy fight
- CR 1/2: Medium fight
- CR 1: Hard fight
- CR 2+: Deadly fight

General formula: max_cr = character_level / 4
```

## Additional Combat Concepts

### Advantage and Disadvantage

**Advantage** (Roll twice, take higher):
- Attacking an enemy that can't see you
- Attacking a prone enemy (melee)
- Help action from ally

**Disadvantage** (Roll twice, take lower):
- Attacking while prone
- Attacking an enemy you can't see
- Attacking at long range

**Example:**
```
Normal attack: Roll 1d20+5 → 12+5 = 17
Advantage: Roll 2d20+5 → (12, 18)+5 = 23 (take higher)
Disadvantage: Roll 2d20+5 → (12, 18)+5 = 17 (take lower)
```

### Cover

- **Half Cover**: +2 AC and DEX saves
- **Three-Quarters Cover**: +5 AC and DEX saves
- **Full Cover**: Cannot be targeted

### Conditions (Future Tutorial)

- **Prone**: Disadvantage on attacks, advantage for melee attackers
- **Grappled**: Speed = 0
- **Restrained**: Disadvantage on attacks and DEX saves
- **Stunned**: Can't act, auto-fail STR/DEX saves
- Many more...

## Quick Reference Tables

### Dice Reading

- **d4**: Four-sided die (1-4)
- **d6**: Six-sided die (1-6)
- **d8**: Eight-sided die (1-8)
- **d10**: Ten-sided die (1-10)
- **d12**: Twelve-sided die (1-12)
- **d20**: Twenty-sided die (1-20)

### Common Weapons

| Weapon      | Damage  | Type      | Properties           |
|-------------|---------|-----------|----------------------|
| Longsword   | 1d8     | Slashing  | Versatile (1d10)     |
| Shortsword  | 1d6     | Piercing  | Finesse, Light       |
| Mace        | 1d6     | Bludgeon  | -                    |
| Quarterstaff| 1d6     | Bludgeon  | Versatile (1d8)      |
| Scimitar    | 1d6     | Slashing  | Finesse, Light       |
| Shortbow    | 1d6     | Piercing  | Ranged (80/320)      |

### Starting Equipment by Class

**Fighter:**
- Chain mail (AC 16)
- Longsword (1d8+STR slashing, versatile)
- Shield (+2 AC)
- **Total AC**: 18

**Wizard:**
- No armor (AC 10+DEX)
- Quarterstaff (1d6+STR bludgeoning)
- **Total AC**: 10+DEX

**Rogue:**
- Leather armor (AC 11+DEX)
- Shortsword (1d6+DEX piercing, finesse)
- **Total AC**: 11+DEX

**Cleric:**
- Chain mail (AC 16)
- Mace (1d6+STR bludgeoning)
- Shield (+2 AC)
- **Total AC**: 18

## Further Reading

For complete D&D 5th Edition rules, consult:
- Player's Handbook (PHB)
- Dungeon Master's Guide (DMG)
- Basic Rules (free online at dndbeyond.com)

This reference covers the subset of rules implemented in Tutorial 4. Future tutorials will expand on these mechanics with conditions, reactions, bonus actions, and more complex combat scenarios.
