# Radio Drama Narrative Guide for D&D Combat

## Philosophy

Present combat encounters as a **radio drama** - paint vivid pictures with words so the listener can see, hear, and feel the action. Act as a Dungeon Master bringing the scene to life through descriptive language, atmosphere, and emotional engagement.

The goal is to make every combat feel cinematic and memorable, even though it's happening entirely through text.

## Combat Opening - Setting the Stage

When combat begins (after running `combat.py start`), create atmosphere using the combat data to build anticipation and excitement.

### Set the Scene

Describe the training arena environment to ground the player in the space:
- Physical details: torchlight flickering on stone walls, sand crunching underfoot, weapon racks lining the perimeter
- Atmosphere: tension in the air, smell of sweat and steel, echo of footsteps
- Sensory details: temperature, sounds, lighting conditions

### Monster Introduction

Use the monster's stats to inform your description:
- **High DEX**: Describe as quick, agile, nimble, darting movements
- **High STR**: Describe as hulking, powerful, massive, intimidating presence
- **High CON**: Describe as tough, resilient, hardy, battle-scarred
- **Low stats**: Describe as frail, clumsy, or weak in that area

Give each monster type a distinct personality:
- **Goblin**: Cunning, nasty, cackling, malicious intelligence, cowardly when hurt
- **Skeleton**: Relentless, hollow, eerie, emotionless, mechanical movements
- **Zombie**: Shambling, groaning, mindless, inexorable, rotting
- **Orc**: Fierce, aggressive, brutal, roaring, bloodthirsty
- **Rat**: Skittering, chittering, beady-eyed, nervous, quick

### Initiative Drama

Build tension around who strikes first:
- Describe the moment before combat begins (both combatants sizing each other up)
- Use initiative rolls to narrate WHY someone goes first
  - High roll: "Lightning reflexes!" "Explosive speed!" "Anticipates the attack!"
  - Low roll: "Caught off guard!" "Hesitates for a fatal moment!" "Slow to react!"
- Create a dramatic pause: "Who will strike first?"

### Example Combat Opening

```
⚔️  TRAINING ARENA ⚔️

The heavy wooden doors creak open, and Bob steps into the torch-lit arena.
Sand crunches beneath his boots. The air smells of sweat and steel, thick
with the anticipation of combat.

From the shadows across the arena, a hunched figure emerges—a Goblin!
Its yellow eyes gleam with malicious intelligence as it draws a wicked
curved scimitar. The creature cackles, crouching low, ready to pounce.

The tension is palpable. Both warriors eye each other, muscles coiled...

Initiative:
- Bob rolled 15 + 1 (DEX) = 16
- Goblin rolled 20 + 2 (DEX) = 22

The Goblin EXPLODES into motion with startling speed! Bob barely has time
to raise his shield before the creature is upon him!

Combat State:
- Bob: 11/11 HP, AC 18 - Armored and ready
- Goblin: 11/11 HP, AC 15 - Fast and dangerous
```

## During Combat - Turn-by-Turn Action

Every attack, spell, or action should be narrated with attention to detail and variety.

### Attack Declarations

Before showing dice rolls, describe the action in progress:
- **Character positioning**: "Bob circles left, looking for an opening..."
- **Weapon grip and stance**: "Gripping his longsword with both hands..."
- **Facial expression**: "Eyes narrowed in concentration..."
- **Intent**: "A desperate lunge!" "A calculated strike!" "Fury in every movement!"
- **Environmental details**: "Dust kicked up by quick footwork..." "Torchlight glinting off raised steel..."

### Attack Results - HITS

Describe the impact viscerally based on damage amount:

**Light damage (1-3)**: Glancing blow, superficial
```
The blade catches the Goblin's shoulder, drawing blood but little more.
A flesh wound - painful but not debilitating.
```

**Solid hit (4-7)**: Meaningful impact
```
Your longsword bites deep into the Goblin's side with a meaty THUNK!
The creature howls in pain, staggering backward, dark blood seeping
through its leather armor.
```

**Heavy damage (8+)**: Devastating blow
```
The mace CRASHES into the Skeleton's ribcage with bone-shattering force!
Ribs explode in a spray of fragments, the undead horror nearly torn in half
by the brutal impact.
```

Always include:
- Sound effects (THUNK, CRASH, CRUNCH, SLASH)
- Monster/character reactions (howl, grimace, stagger, gasp)
- Physical consequences matching damage (blood spray, bone crack, armor dent)

### Attack Results - MISSES

Never just say "miss" - explain WHY the attack failed:

**Armor deflection**:
```
Your blade skitters off the Goblin's leather armor, unable to find purchase.
```

**Dodge**:
```
The Skeleton twists aside at the last instant, your sword whistling through
empty air where its skull had been a heartbeat before.
```

**Parry**:
```
Metal rings against metal as the Orc's scimitar catches your blade,
deflecting it away with practiced ease.
```

**Near-miss**:
```
Your thrust comes within inches of the Zombie's head, but the shambling
corpse lurches backward just in time.
```

Build tension with close calls:
```
SO CLOSE! The arrow grazes the Goblin's ear, drawing a thin line of blood
but dealing no real damage. The creature flinches but grins wickedly.
```

### Critical Hits - Maximum Drama

Critical hits deserve special treatment:

1. **Slow down time** - Use longer sentences, more detail
2. **Describe the perfect opening** - Why this moment is special
3. **Epic impact description** - Multiple sensory details
4. **Use dramatic formatting** - Emojis, caps, emphasis

**Example critical hit**:
```
⚡ CRITICAL HIT! ⚡

Time seems to slow as Bob spots the perfect opening—the Goblin overextends
on a wild slash, exposing its entire left side. Bob's eyes widen. This is it.

He pivots on his back foot, bringing his longsword around in a devastating
horizontal arc. The blade catches torchlight as it sweeps toward the Goblin's
unprotected ribs.

💥 IMPACT! 💥

The longsword cleaves through leather, flesh, and bone with a sickening
CRUNCH! The Goblin's scream is cut short as it's lifted off its feet by
the sheer force of the blow, hurled backward into the sand.

🎲 Critical damage: 14 slashing!

The Goblin lies crumpled, twitching weakly. Blood pools in the sand.
HP: -3/11 - Utterly destroyed!
```

### Spellcasting Narration

Spells require different narrative approaches based on their type:

**Spell Attacks (Fire Bolt, Ray of Frost)**:
```
You extend your hand, arcane syllables spilling from your lips. A mote
of fire coalesces in your palm, then streaks toward the Goblin like a
tiny meteor!

🎲 Spell attack: 14 + 5 = 19 vs AC 15 - HIT!
🔥 Damage: 7 fire

The fire bolt SLAMS into the Goblin's chest, igniting its leather armor!
The creature screams, batting at the flames. HP: 4/11
```

**Saving Throw Spells (Burning Hands, Thunderwave)**:
```
You thrust your hands forward, fingers spread wide, and speak the words
of power. A cone of roaring flames erupts from your fingertips, washing
over the Goblin in a wave of heat and fire!

🎲 Goblin DEX save vs DC 13: 4 + 2 = 6 - FAILED!
🔥 Damage: 10 fire (full damage on failed save)

The Goblin's scream is drowned out by the roar of flames. When the fire
dissipates, the creature collapses, smoking and charred. HP: 1/11

💎 Spell slot consumed: 1/2 remaining
```

**Auto-Hit Spells (Magic Missile)**:
```
You point at the Skeleton and three glowing darts of pure magical force
materialize around your hand. With a gesture, they lance forward, unerring
and unstoppable!

✨ 3 magic missiles strike automatically!
🎯 Damage: 3 + 4 + 4 = 11 force damage

The missiles SLAM into the Skeleton's ribcage, sternum, and skull in rapid
succession—WHAP WHAP WHAP! Bone cracks spiderweb across its frame.
HP: -4/7

💎 Spell slot consumed: 0/2 remaining
```

### HP Status Narration

Match narrative intensity to remaining HP percentage:

**75-100% HP**: Fresh and confident
```
Bob stands tall, breathing steadily. Barely winded.
The Goblin circles warily, looking for an opening.
```

**50-74% HP**: Bloodied but determined
```
Bob wipes blood from a cut above his eye, breathing harder now.
The Goblin favors its wounded leg, but its eyes still burn with malice.
```

**25-49% HP**: Wounded and desperate
```
Bob clutches his side, blood seeping between his fingers. Every breath hurts.
The Goblin staggers, one arm hanging useless, but it refuses to fall.
```

**1-24% HP**: On death's door
```
Bob can barely stand, vision swimming, holding his weapon through pure willpower.
The Goblin crawls through the sand, broken but not beaten, eyes wild with desperation.
```

**0 HP**: The final moment
```
Bob's knees buckle. The longsword falls from nerveless fingers. He pitches
forward into the sand, darkness closing in. Defeated.

The Goblin collapses mid-laugh, its scimitar clattering away. It twitches once,
twice, then lies still. The arena falls silent.
```

### Vary Your Language

Avoid repetition by using rich vocabulary:

**Attack verbs**:
- swing, slash, thrust, strike, lunge, cleave, drive, plunge
- hack, chop, stab, pierce, cut, slice, carve
- smash, bash, crush, pound, hammer

**Defensive moves**:
- dodge, weave, duck, sidestep, roll, leap, pivot, twist
- parry, block, deflect, intercept

**Movement**:
- charge, rush, dart, sprint, dash, lunge
- circle, retreat, advance, close distance
- stagger, stumble, reel, fall back

**Sounds**:
- clang, ring, thud, crack, whistle, crunch, scrape
- whoosh, clash, snap, thump, clatter
- roar, scream, howl, groan, gasp

**Sensory details**:
- flash of steel, spray of blood, cloud of dust
- bitter tang of fear, metallic smell of blood
- heat of flames, cold of death, weight of exhaustion

## Victory and Defeat - Ending Combat

When combat ends, provide a satisfying narrative conclusion.

### Victory

Describe the killing blow in detail, then transition to the aftermath:

```
Bob sees his opening—the Goblin overextends on a wild slash. He pivots,
bringing his longsword down in a brutal overhead chop!

🎲 Attack roll: 19 + 5 = 24 vs AC 15
💥 DEVASTATING HIT! Damage: 9 slashing

The blade cleaves through the Goblin's collarbone with a sickening CRUNCH.
The creature's eyes go wide, scimitar clattering to the sand. It crumples,
twitching once, then lies still.

Silence falls over the arena. Bob lowers his sword, chest heaving.
Blood drips from the blade to hiss in the sand. Victory.

🏆 The battle is won!

Golden light washes over Bob as magical healing suffuses his battered body.
Wounds close, bruises fade, strength returns. He stands tall, ready for
whatever comes next.

Final Status: Bob 11/11 HP - Victorious and renewed!
```

### Defeat

Treat defeat respectfully, focusing on the struggle and what was learned:

```
The Goblin's scimitar flashes out faster than Bob can react. The blade
finds the gap in his armor, driving deep into his side.

🎲 Attack roll: 18 + 4 = 22 vs AC 18 - CRITICAL HIT!
💥 Damage: 12 slashing

Bob gasps, the world tilting. His longsword falls from nerveless fingers.
He tries to speak, to fight, but darkness rushes in from all sides.

He collapses into the sand.

💀 Defeat.

The training master rushes in, calling for healers. Bob will survive this,
but the lesson is clear: the Goblin was simply too fast, too skilled today.
There is no shame in defeat, only the opportunity to learn and grow stronger.

Bob will heal and try again.
```

### Fleeing

Handle fleeing as a tactical choice, not cowardice:

```
Bob sees the writing on the wall—this Orc is beyond his skill level right now.
Better to retreat and return stronger than to fall here.

"Another time!" Bob shouts, then turns and sprints for the exit.

🎲 DEX check: 16 + 1 = 17 - SUCCESS!

The Orc roars and gives chase, but Bob's lighter armor gives him the edge.
He bursts through the arena doors and slams them shut, the Orc's frustrated
bellow echoing behind him.

🏃 Escaped!

Magical healing washes over Bob as he leans against the door, catching his
breath. He lives to fight another day—and next time, he'll be ready.

Final Status: Bob 11/11 HP - Tactical retreat successful!
```

## Important Narrative Guidelines

1. **Always show dice rolls** - Transparency builds trust and teaches mechanics
   - Format: `🎲 Roll: 15 + 4 = 19 vs AC 15`

2. **Status updates after every action** - Clear HP tracking prevents confusion
   - Format: `HP: 6/11` or `The Goblin now has 3/7 HP remaining`

3. **Pacing matters**
   - Short, punchy sentences for action: "Bob swings. The Goblin dodges. Steel meets steel."
   - Longer, descriptive sentences for atmosphere: "The training arena is silent except for the hiss of torches and the rasp of heavy breathing."

4. **Emotion and stakes**
   - Characters should feel fear when low on HP
   - Show determination in the face of adversity
   - Relief and triumph in victory
   - Respect in defeat

5. **Consistency in monster personality**
   - Goblins: Cackling, taunting, cowardly when losing
   - Skeletons: Silent, relentless, emotionless
   - Zombies: Groaning, mindless, inexorable
   - Orcs: Roaring, aggressive, honorable in their brutality

6. **Player agency and heroism**
   - Make the player character feel skilled and capable
   - Their choices matter
   - Even in defeat, they fought well

7. **Use formatting for emphasis**
   - ⚔️ for combat start
   - 🎲 for dice rolls
   - 💥 for impacts
   - 🔥 for fire damage
   - ❄️ for cold damage
   - ⚡ for lightning/thunder
   - ✨ for magic effects
   - 🏆 for victory
   - 💀 for defeat

## Additional Example Scenarios

### Low-Level Character vs. Rat (Easy Victory)

```
You enter the training arena and—wait, is that your opponent?

A mangy rat, no bigger than your boot, sits in the center of the sand.
It notices you and HISSES, baring tiny fangs.

Well. This should be quick.

Initiative:
- You: 8 + 1 = 9
- Rat: 14 + 2 = 16

The rat CHARGES with surprising aggression!

🎲 Rat attacks: 12 + 0 = 12 vs AC 18 - MISS!

It leaps at your boot and you simply step aside. The rat lands in the sand,
confused about where you went.

Your turn. What do you do?

[Player attacks]

🎲 Attack: 11 + 4 = 15 vs AC 10 - HIT!
⚔️ Damage: 6 slashing

Your longsword comes down in a swift arc. The rat doesn't even have time
to squeak. HP: -5/1

Well. That was... anticlimactic.

🏆 Victory! (You feel slightly silly.)
```

### Equal-Strength Battle (Back-and-Forth)

```
⚔️ TRAINING ARENA ⚔️

Bob faces off against a Skeleton—animated bones held together by dark magic.
Empty eye sockets burn with eldritch light. It raises a rusty shortsword.

Initiative:
- Bob: 16
- Skeleton: 8

Bob goes first!

[Bob attacks]
🎲 Attack: 13 + 4 = 17 vs AC 13 - HIT!
💥 Damage: 7 bludgeoning

Bob's mace CRACKS into the Skeleton's ribcage! Bones splinter. HP: 6/13

The Skeleton doesn't flinch, doesn't cry out. It simply counterattacks.

🎲 Skeleton attacks: 15 + 4 = 19 vs AC 16 - HIT!
⚔️ Damage: 4 slashing

The shortsword opens a gash across Bob's arm! HP: 7/11

[Another round of back-and-forth]

This is a real fight. Both warriors trade blows, neither giving ground.

[Eventually Bob lands the killing blow]

Bob's mace comes down with all his remaining strength—SMASH!

The Skeleton's skull explodes in a shower of bone fragments! The rest of
the bones clatter to the ground, magic extinguished.

🏆 Victory! Hard-fought and well-earned.
```

### Spellcaster Running Out of Resources

```
[Combat in progress - wizard has used both spell slots]

Mira breathes hard, sweat running down her face. Two spell slots spent.
The Goblin still stands, bloodied but defiant.

"Out of fancy magic, wizard?" it taunts.

Mira grips her quarterstaff tighter. Time to do this the old-fashioned way.

What do you do?
> Attack with quarterstaff

Mira swings her staff in a wide arc!

🎲 Attack: 8 + 2 = 10 vs AC 15 - MISS!

The Goblin ducks under the swing, cackling.

🎲 Goblin attacks: 16 + 4 = 20 vs AC 12 - HIT!
⚔️ Damage: 5 slashing

The scimitar bites into Mira's shoulder! HP: 3/8

Mira staggers. This is getting desperate. One more good hit might end her.

What do you do?
> Attack with quarterstaff

Mira grits her teeth and swings again, putting everything into it!

🎲 Attack: 19 + 2 = 21 vs AC 15 - HIT!
💥 Damage: 5 bludgeoning!

CRACK! The staff catches the Goblin right in the temple! Its eyes roll back
and it drops like a puppet with cut strings. HP: -2/7

🏆 Victory!

Mira falls to her knees, gasping. No magic required—just determination and
a well-placed swing. Sometimes the simple solutions are best.
```

Remember: Every combat is a story. Make it memorable.
