# Spellcasting System Documentation

## Overview

Tutorial 4 introduces a complete spellcasting system with spell slot management, multiple damage types, and three distinct resolution mechanics. This system allows characters to cast both cantrips (unlimited use) and leveled spells (limited by spell slots).

## Spell Types

### Cantrips (Level 0)

Cantrips are minor magical abilities that can be cast unlimited times without consuming spell slots.

**Available Cantrips:**
- **Fire Bolt**: Hurl a mote of fire (1d10 fire damage, spell attack)
- **Ray of Frost**: Blast of frigid air (1d8 cold damage, spell attack)
- **Shocking Grasp**: Crackling lightning touch (1d8 lightning damage, spell attack)
- **Sacred Flame**: Radiant flame descends on foe (1d8 radiant damage, DEX save)
- **Eldritch Blast**: Crackling energy beam (1d10 force damage, spell attack)

**Cantrip Characteristics:**
- No spell slot cost
- Can be cast every turn if desired
- Scale with character level (damage increases at levels 5, 11, 17)
- Perfect for resource conservation

### Leveled Spells (Level 1+)

Leveled spells are more powerful but consume spell slots when cast. Characters have a limited number of spell slots that refresh on a long rest.

**Available Level 1 Spells:**
- **Magic Missile**: Three darts of magical force (3d4+3 force damage, auto-hit)
- **Burning Hands**: 15-ft cone of fire (3d6 fire damage, DEX save)
- **Thunderwave**: 15-ft cube of thunder (2d8 thunder damage, CON save)
- **Shield**: Invisible barrier of force (+5 AC until start of next turn)
- **Healing Word**: Heal a creature within 60 ft (1d4+modifier HP restored)

**Leveled Spell Characteristics:**
- Consume one spell slot when cast
- More powerful than cantrips
- Limited uses per day
- Require strategic resource management

## Spell Resolution Mechanics

Different spells use different mechanics to determine success and damage.

### Spell Attacks

Spells like Fire Bolt, Ray of Frost, and Shocking Grasp require the caster to make a spell attack roll against the target's Armor Class.

**Mechanic:**
1. Roll d20 + spell attack bonus
2. Compare to target's AC
3. On hit: Roll damage dice
4. On miss: No effect

**Formula:**
```
Spell attack bonus = Proficiency bonus + Spellcasting ability modifier
```

**Example:**
```
Character: Level 1 Wizard (INT 16, +3 modifier, +2 proficiency)
Spell attack bonus: +2 (proficiency) + +3 (INT) = +5

Casting Fire Bolt at a Goblin (AC 15):
🎲 Attack roll: 14 + 5 = 19 vs AC 15 - HIT!
🔥 Damage: 1d10 = 7 fire damage
```

**Spell Attack Spells:**
- Fire Bolt (1d10 fire)
- Ray of Frost (1d8 cold)
- Shocking Grasp (1d8 lightning)
- Eldritch Blast (1d10 force)

### Saving Throws

Spells like Burning Hands, Thunderwave, and Sacred Flame force the target to make a saving throw against the caster's spell save DC.

**Mechanic:**
1. Caster declares spell
2. Target rolls d20 + appropriate save modifier
3. Compare to caster's spell save DC
4. On failed save: Take full damage (or effect occurs)
5. On successful save: Take half damage or no effect (spell-dependent)

**Formula:**
```
Spell save DC = 8 + Proficiency bonus + Spellcasting ability modifier
```

**Example:**
```
Character: Level 1 Wizard (INT 16, +3 modifier, +2 proficiency)
Spell save DC: 8 + 2 (proficiency) + 3 (INT) = 13

Casting Burning Hands at a Goblin (DEX +2):
🎲 Goblin DEX save: 4 + 2 = 6 vs DC 13 - FAILED!
🔥 Damage: 3d6 = 10 fire damage (full damage)

If the Goblin had rolled 11 or higher:
🔥 Damage: 5 fire damage (half damage, rounded down)
```

**Saving Throw Types:**
- **DEX saves**: Dodging area effects (Burning Hands, Thunderwave)
- **CON saves**: Resisting physical effects (Thunderwave alternative)
- **WIS saves**: Resisting mental effects
- **Other saves**: STR, INT, CHA (less common)

**Saving Throw Spells:**
- Sacred Flame (1d8 radiant, DEX save, no damage on success)
- Burning Hands (3d6 fire, DEX save, half damage on success)
- Thunderwave (2d8 thunder, CON save, half damage on success)

### Auto-Hit

Spells like Magic Missile automatically hit without requiring an attack roll or saving throw.

**Mechanic:**
1. Spell is cast
2. Damage is rolled
3. Damage is applied (no roll to hit)

**Example:**
```
Casting Magic Missile at a Goblin:
✨ 3 magic missiles strike automatically!
🎯 Damage: 1d4+1 per missile = (3)+(4)+(2) = 9 force damage
No attack roll needed - always hits!
```

**Auto-Hit Spells:**
- Magic Missile (3 × [1d4+1] force damage)
- Healing Word (1d4+modifier healing, always works)
- Shield (+5 AC, always works)

## Spell Slot Management

Spell slots represent a character's magical energy reserves. Casting a leveled spell consumes one slot.

### Spell Slots by Class

**Full Casters** (Wizard, Sorcerer, Cleric, Druid):
- Level 1: 2 spell slots
- Level 2: 3 spell slots
- Level 3: 4 spell slots (+ 2 level-2 slots)
- (And so on...)

**Half Casters** (Paladin, Ranger):
- Gain spell slots more slowly
- Level 2: 2 spell slots
- Level 3: 3 spell slots
- (And so on...)

**Non-Casters** (Fighter, Rogue, Barbarian):
- No spell slots
- Cannot cast leveled spells
- May have cantrips from racial features or feats

### Tracking Spell Slots

The `character.py` script automatically tracks spell slots in the database.

**When a leveled spell is cast:**
```bash
python3 scripts/combat.py character-cast CHARACTER_NAME "Burning Hands" ...
```

The script:
1. Checks if character has available spell slots
2. If yes: Casts spell and decrements spell slots by 1
3. If no: Returns error (cannot cast without spell slots)
4. Updates character database with new slot count

**Restoring spell slots:**
```bash
python3 scripts/character.py long-rest CHARACTER_NAME
```

This restores the character to full HP and refreshes all spell slots.

### Strategic Considerations

**Cantrip vs. Leveled Spell Decision:**
- **Use cantrips** for weak enemies or when conserving resources
- **Use leveled spells** for tough enemies or critical moments
- **Save at least one slot** for emergencies

**Example scenario:**
```
Battle vs. Goblin (7 HP, AC 15):
- Fire Bolt cantrip: 1d10 (avg 5.5) damage, unlimited uses
- Burning Hands: 3d6 (avg 10.5) damage, consumes precious spell slot

Decision: Use Fire Bolt to conserve spell slots for tougher fights
```

## Spellcasting Stats by Class

Each spellcasting class uses a different ability score for their magic.

### Wizard (Intelligence)

**Spellcasting Ability:** Intelligence
**Flavor:** Wizards study ancient tomes and master arcane formulas

**Spell Attack Bonus:**
```
+2 (proficiency at level 1) + INT modifier
```

**Spell Save DC:**
```
8 + 2 (proficiency) + INT modifier
```

**Example:** Wizard with INT 16 (+3)
- Spell attack: +5
- Spell save DC: 13

### Sorcerer (Charisma)

**Spellcasting Ability:** Charisma
**Flavor:** Sorcerers have innate magical talent flowing through their blood

**Spell Attack Bonus:**
```
+2 (proficiency at level 1) + CHA modifier
```

**Spell Save DC:**
```
8 + 2 (proficiency) + CHA modifier
```

**Example:** Sorcerer with CHA 14 (+2)
- Spell attack: +4
- Spell save DC: 12

### Warlock (Charisma)

**Spellcasting Ability:** Charisma
**Flavor:** Warlocks gain power through pacts with otherworldly beings

**Spell Attack Bonus:**
```
+2 (proficiency at level 1) + CHA modifier
```

**Spell Save DC:**
```
8 + 2 (proficiency) + CHA modifier
```

**Example:** Warlock with CHA 16 (+3)
- Spell attack: +5
- Spell save DC: 13

### Cleric (Wisdom)

**Spellcasting Ability:** Wisdom
**Flavor:** Clerics channel divine power granted by their deity

**Spell Attack Bonus:**
```
+2 (proficiency at level 1) + WIS modifier
```

**Spell Save DC:**
```
8 + 2 (proficiency) + WIS modifier
```

**Example:** Cleric with WIS 15 (+2)
- Spell attack: +4
- Spell save DC: 12

### Druid (Wisdom)

**Spellcasting Ability:** Wisdom
**Flavor:** Druids draw magic from nature itself

**Spell Attack Bonus:**
```
+2 (proficiency at level 1) + WIS modifier
```

**Spell Save DC:**
```
8 + 2 (proficiency) + WIS modifier
```

**Example:** Druid with WIS 14 (+2)
- Spell attack: +4
- Spell save DC: 12

## Damage Types

Spells deal different damage types, which may interact with monster resistances and vulnerabilities.

### Damage Type Descriptions

- **Fire**: Burning flames and heat
- **Cold**: Freezing ice and frost
- **Lightning**: Electrical energy and sparks
- **Thunder**: Concussive sound waves
- **Force**: Pure magical energy
- **Radiant**: Divine light and holy power
- **Necrotic**: Death energy and decay
- **Acid**: Corrosive liquid
- **Poison**: Toxic substances

### Monster Resistances (Future Expansion)

In a more advanced system, monsters might have:
- **Resistance**: Take half damage from specific types
- **Vulnerability**: Take double damage from specific types
- **Immunity**: Take no damage from specific types

**Example (not yet implemented):**
```
Fire Elemental:
- Immune to fire damage
- Vulnerable to cold damage

Casting Fire Bolt (1d10 fire): 0 damage (immune)
Casting Ray of Frost (1d8 cold): Double damage (vulnerable)
```

## Advanced Topics

### Concentration (Future Tutorial)

Some spells require concentration to maintain:
- Can only concentrate on one spell at a time
- Taking damage may break concentration (CON save)
- Casting another concentration spell ends the first

### Upcasting (Future Tutorial)

Casting spells using higher-level slots:
- Increases damage or effects
- Example: Magic Missile cast with 2nd-level slot = 4 missiles instead of 3

### Ritual Casting (Future Tutorial)

Some spells can be cast as rituals:
- Takes 10 extra minutes
- Doesn't consume a spell slot
- Useful for utility spells outside combat

## Spell Database Management

The `spells.py` script provides commands for managing the spell database.

### Seeding Initial Spells

First-time setup:
```bash
python3 scripts/spells.py seed
```

This loads all spells from `assets/data/spells_core.json` into the database.

### Listing Spells

**All spells:**
```bash
python3 scripts/spells.py list
```

**By level:**
```bash
python3 scripts/spells.py list --level 0    # Cantrips
python3 scripts/spells.py list --level 1    # Level 1 spells
```

**By class:**
```bash
python3 scripts/spells.py list --class wizard
python3 scripts/spells.py list --class cleric
```

### Getting Spell Details

**Human-readable format:**
```bash
python3 scripts/spells.py show "Fire Bolt"
```

Output:
```
Fire Bolt
Level: 0 (Cantrip)
School: Evocation
Classes: Wizard, Sorcerer
Casting Time: 1 action
Range: 120 feet
Components: V, S
Duration: Instantaneous

You hurl a mote of fire at a creature or object within range...

Attack Type: spell_attack
Damage: 1d10 fire
```

**JSON format (for scripts):**
```bash
python3 scripts/spells.py get "Fire Bolt"
```

Output:
```json
{
  "name": "Fire Bolt",
  "level": 0,
  "school": "Evocation",
  "classes": ["wizard", "sorcerer"],
  "attack_type": "spell_attack",
  "damage_dice": "1d10",
  "damage_type": "fire",
  ...
}
```

## Integration with Combat System

During combat, the `combat.py` script handles spell casting:

```bash
python3 scripts/combat.py character-cast CHARACTER_NAME "SPELL_NAME" MONSTER_NAME MONSTER_AC MONSTER_HP 'MONSTER_STATS_JSON'
```

The script:
1. Looks up spell in database
2. Checks if character has spell slots (for leveled spells)
3. Determines resolution mechanic (attack, save, or auto-hit)
4. Rolls appropriate dice
5. Calculates damage
6. Updates monster HP
7. Decrements spell slots (if leveled spell)
8. Returns JSON with full results

This automation ensures consistent spell mechanics and proper resource tracking.
