# Complete Theme Taxonomy for User Feedback

## Purpose

This taxonomy provides a standardized framework for categorizing user feedback. Use it to ensure consistency across analyses and enable cross-project comparisons.

---

## Primary Categories (L1)

### 1. USABILITY
Issues related to ease of use, learnability, and user experience

**Subcategories:**
- **Navigation:** Difficulty finding features, confusing menu structure
- **Clarity:** Unclear labels, confusing terminology, ambiguous instructions
- **Learning Curve:** Steep learning curve, complex interface, overwhelming
- **Accessibility:** Screen reader issues, keyboard navigation, color contrast
- **Error Handling:** Unclear error messages, no recovery options
- **Help/Documentation:** Missing tooltips, inadequate help content

**Example Feedback:**
- "Can't figure out how to export my data"
- "Took me 20 minutes to find the settings"
- "Error message just says 'Something went wrong'"

---

### 2. FEATURES
Requests for new functionality, enhancements, or missing capabilities

**Subcategories:**
- **Core Functionality:** Essential features missing from product
- **Nice-to-Have:** Convenience features, quality-of-life improvements
- **Customization:** Personalization options, user preferences
- **Automation:** Workflow automation, batch operations
- **Collaboration:** Team features, sharing, permissions
- **Reporting/Analytics:** Dashboards, insights, data visualization
- **Import/Export:** Data portability, integrations

**Example Feedback:**
- "Need ability to bulk edit items"
- "Would love a dark mode option"
- "Can't collaborate with team members"

---

### 3. PERFORMANCE
Technical performance issues affecting user experience

**Subcategories:**
- **Speed/Latency:** Slow loading, laggy interface, delays
- **Reliability:** Crashes, freezes, hangs
- **Bugs:** Functional errors, broken features
- **Data Loss:** Lost work, failed saves, sync issues
- **Scalability:** Performance degrades with large datasets
- **Offline Capability:** Requires constant connection

**Example Feedback:**
- "App crashes every time I try to export"
- "Takes 10 seconds to load each page"
- "Lost all my work when browser crashed"

---

### 4. PRICING
Cost-related concerns and value perception

**Subcategories:**
- **Too Expensive:** General price complaints
- **Value Perception:** Not worth the cost
- **Billing Issues:** Payment problems, unexpected charges
- **Plan Limitations:** Free tier too restricted, need middle tier
- **Pricing Structure:** Confusing tiers, hidden costs
- **Trial/Freemium:** Trial too short, free version inadequate
- **ROI Concerns:** Can't justify cost to manager

**Example Feedback:**
- "$99/month is too expensive for small teams"
- "Free plan is basically unusable"
- "Was charged twice this month"

---

### 5. SUPPORT
Customer service, documentation, and help resources

**Subcategories:**
- **Response Time:** Slow support responses
- **Support Quality:** Unhelpful responses, issue unresolved
- **Documentation:** Missing docs, outdated guides
- **Self-Service:** Can't find answers, FAQ inadequate
- **Onboarding Help:** Need more guidance during setup
- **Training Resources:** Want tutorials, webinars, videos
- **Community:** Forum inactive, no user community

**Example Feedback:**
- "Support took 3 days to respond"
- "Documentation doesn't cover my use case"
- "Wish there was a video tutorial"

---

### 6. ONBOARDING
First-time user experience and initial setup

**Subcategories:**
- **Signup Friction:** Too many required fields, verification issues
- **Setup Complexity:** Difficult initial configuration
- **No Guidance:** Lack of tutorial, unclear next steps
- **Data Import:** Can't import existing data easily
- **Activation Time:** Takes too long to get first value
- **Expectations Mismatch:** Product different than expected

**Example Feedback:**
- "No idea what to do after signing up"
- "Importing my data was a nightmare"
- "Abandoned setup because it was too complicated"

---

### 7. INTEGRATIONS
Third-party connections, APIs, and ecosystem

**Subcategories:**
- **Missing Integrations:** Want specific tool integration
- **Integration Quality:** Existing integrations buggy
- **API Access:** Need API, better API documentation
- **Import/Export Formats:** Support more file types
- **Single Sign-On:** Want SSO, SAML support
- **Webhooks:** Real-time notifications needed
- **Plugin Ecosystem:** Want extensions, add-ons

**Example Feedback:**
- "Desperately need Slack integration"
- "Zapier connection keeps breaking"
- "No API for custom integrations"

---

### 8. DESIGN
Visual design, aesthetics, and UI polish

**Subcategories:**
- **Visual Appearance:** Outdated look, ugly interface
- **Consistency:** Inconsistent styling across pages
- **Responsiveness:** Poor mobile design, doesn't scale
- **Information Density:** Too cluttered or too sparse
- **Branding:** Doesn't match our brand
- **Customization:** Can't customize appearance
- **Dark Mode:** Want dark theme option

**Example Feedback:**
- "UI looks like it's from 2010"
- "Mobile version is unusable"
- "Too much white space, wasted screen"

---

### 9. SECURITY/PRIVACY
Data protection, compliance, and trust

**Subcategories:**
- **Data Privacy:** Concerns about data usage
- **Security Features:** 2FA, encryption, access controls
- **Compliance:** GDPR, HIPAA, SOC 2 requirements
- **Data Location:** Want data stored in specific region
- **Permissions:** Granular access control needed
- **Audit Logs:** Need activity tracking
- **Data Deletion:** Can't fully delete data

**Example Feedback:**
- "No two-factor authentication option"
- "Need GDPR compliance before we can use"
- "Worried about data being sold"

---

### 10. MOBILE
Mobile app or mobile web experience

**Subcategories:**
- **Missing Mobile App:** No iOS/Android app
- **Mobile App Bugs:** App-specific issues
- **Feature Parity:** Mobile missing key features
- **Mobile Performance:** App slow or crashes
- **Offline Mode:** Need offline capability
- **Tablet Experience:** Poor iPad/tablet experience
- **Push Notifications:** Want mobile alerts

**Example Feedback:**
- "No mobile app is a dealbreaker"
- "iPhone app crashes constantly"
- "Can't do half the things I can on desktop"

---

## Secondary Tags

### Sentiment Tags
- **Very Positive:** Praise, love, exceptional satisfaction
- **Positive:** Appreciation, satisfaction, working well
- **Neutral:** Factual observation, neither positive nor negative
- **Negative:** Frustration, disappointment, complaint
- **Very Negative:** Anger, severe criticism, threatening to churn

### Urgency Tags
- **Critical:** Showstopper, blocking work, considering cancellation
- **High:** Significant pain point, frequent frustration
- **Medium:** Noticeable issue, occasional annoyance
- **Low:** Minor inconvenience, nice-to-have

### User Segment Tags
- **New User (0-30 days):** Recently signed up
- **Regular User (31-90 days):** Active, established usage
- **Power User (90+ days):** Heavy, sophisticated usage
- **Churned User:** Canceled or stopped using
- **Free Tier:** Using free version
- **Paid Tier:** Paying customer
- **Trial User:** In trial period
- **Enterprise:** Large organization customer

### Request Type Tags
- **Bug Report:** Something is broken
- **Feature Request:** Want new functionality
- **Enhancement:** Improve existing feature
- **Question:** Seeking information/help
- **Praise:** Positive feedback
- **Complaint:** Dissatisfaction with current state

---

## Cross-Cutting Themes

These themes span multiple primary categories:

### Platform-Specific Issues
- **Windows:** Issues specific to Windows users
- **Mac:** macOS-specific problems
- **Linux:** Linux compatibility
- **Chrome:** Browser-specific (also Firefox, Safari, Edge)
- **iOS:** iPhone/iPad issues
- **Android:** Android device issues

### Workflow-Specific Themes
- **Collaboration:** Working with team members
- **Solo Use:** Individual user workflows
- **Admin Tasks:** Account/user management
- **Reporting:** Generating reports/analytics
- **Data Entry:** Inputting information
- **Data Export:** Getting data out

### Industry-Specific Themes
- **Education:** K-12, higher ed specific needs
- **Healthcare:** HIPAA, medical workflows
- **Finance:** Compliance, security requirements
- **E-commerce:** Shopping cart, payments
- **SaaS:** Multi-tenancy, white-labeling

---

## Usage Guidelines

### Categorization Process

1. **Read full feedback** to understand context
2. **Assign primary category** (choose one, most relevant)
3. **Assign subcategory** (can choose multiple if applicable)
4. **Add secondary tags** (sentiment, urgency, segment)
5. **Note cross-cutting themes** if applicable

### Multi-Category Feedback

If feedback touches multiple areas:
- Choose primary category based on main focus
- Note secondary categories in metadata
- Consider splitting into multiple items if distinct issues

**Example:**
> "App is too slow (Performance) and missing export feature (Features). Also, support was unhelpful (Support)."

**Categorization:**
- Primary: Performance (main complaint)
- Secondary: Features, Support
- Subcategories: Speed/Latency, Import/Export, Support Quality

### Handling Ambiguity

**When unclear:**
- Choose most specific category possible
- Add note explaining categorization choice
- Flag for review if truly ambiguous
- Look for similar past feedback for consistency

---

## Special Cases

### Positive Feedback

Categorize by what they're praising:
- "Love the new export feature" → Features (positive sentiment)
- "Support was amazing" → Support (very positive)
- "So easy to use!" → Usability (positive)

### Feature + Bug Combined

> "Export feature exists but is buggy"

- Primary: Performance (Bugs)
- Note: Related to Features (Export)
- This is a quality issue, not a missing feature

### Vague Feedback

> "This product is terrible"

- Primary: Best guess based on context
- Urgency: High (due to strong negative sentiment)
- Flag: Needs follow-up for specifics

### Comparative Feedback

> "Competitor X has this feature"

- Primary: Features (Missing Integrations/etc)
- Add tag: Competitive reference
- Note competitor name in metadata

---

## Taxonomy Evolution

### When to Add New Categories

Consider adding when:
- 10+ feedback items don't fit existing categories
- New product area launched
- Consistent theme emerging across analyses

### When to Merge Categories

Consider merging when:
- Two categories consistently overlap
- One category has <5% of feedback
- Distinction is not actionable

### Periodic Review

- Review taxonomy quarterly
- Update based on product changes
- Ensure consistency across team
- Document changes and reasoning

---

## Example Categorizations

### Example 1: Complex Feedback

**Feedback:** "I love the core product (especially the dashboard), but the mobile app crashes constantly and there's no API access. Also, pricing seems high for what you get."

**Categorization:**
- Primary: Performance (Mobile App Bugs)
- Secondary: Pricing (Too Expensive), Integrations (API Access)
- Sentiment: Mixed (positive about core, negative about issues)
- Urgency: High (mobile crashes)
- Tags: Mobile, Paid Tier
- Positive note: Dashboard praised

### Example 2: Feature Request

**Feedback:** "Please add dark mode! I work late at night and the bright white interface hurts my eyes."

**Categorization:**
- Primary: Design (Dark Mode)
- Subcategory: Customization
- Sentiment: Neutral (polite request)
- Urgency: Medium
- Underlying need: Comfortable late-night usage

### Example 3: Critical Bug

**Feedback:** "Data keeps disappearing! I've lost hours of work. This is completely unacceptable. Considering canceling."

**Categorization:**
- Primary: Performance (Data Loss)
- Sentiment: Very Negative
- Urgency: Critical
- Tag: Churn Risk
- Requires: Immediate follow-up

---

## Quality Checks

**Ensure consistency:**
- [ ] All feedback categorized
- [ ] Primary category assigned to each item
- [ ] Sentiment tagged
- [ ] Urgency level set
- [ ] User segment noted (if known)
- [ ] Ambiguous items flagged
- [ ] Similar items grouped together
- [ ] Outliers identified

**Validation:**
- Sample 10% of categorizations
- Check for consistency
- Resolve disagreements
- Document edge cases
