# Jobs-to-be-Done (JTBD) Framework

Guide complet du framework Jobs-to-be-Done pour comprendre les motivations clients profondes.

## Principe Fondamental

**Les clients n'achètent pas de produits - ils les "embauchent" pour faire un job.**

Un job est un progrès qu'une personne cherche à accomplir dans une circonstance particulière.

## JTBD Statement Structure

```
When [situation],
I want to [motivation],
So I can [expected outcome].
```

### Exemples Réels

**B2B SaaS** :
- "When I'm launching a new product, I want to understand my competitors, so I can position myself effectively."
- "When managing my remote team, I want to track project progress in real-time, so I can deliver on time and identify blockers early."
- "When writing quarterly reports, I want to aggregate data from multiple sources, so I can present clear insights to executives."

**B2C E-commerce** :
- "When shopping for my kids online, I want to find quality products with verified reviews, so I can make confident purchase decisions quickly."
- "When redecorating my home, I want to visualize furniture in my space, so I can avoid costly mistakes."

**SaaS for Freelancers** :
- "When invoicing clients, I want to automate payment reminders, so I can get paid faster without awkward conversations."

## Les 3 Composantes d'un Job

### 1. Functional Job (Tâche Pratique)

Ce que la personne essaie d'accomplir concrètement.

**Exemples** :
- "I need to track website analytics"
- "I want to automate email campaigns"
- "I need to manage customer relationships"
- "I want to create professional invoices"
- "I need to schedule social media posts"

**Questions pour identifier** :
- Quelle tâche spécifique essaient-ils d'accomplir ?
- Quel résultat mesurable cherchent-ils ?
- Comment font-ils actuellement (workaround) ?

### 2. Emotional Job (Comment Ils Veulent Se Sentir)

L'état émotionnel qu'ils cherchent à atteindre ou éviter.

**Exemples** :
- "I want to feel confident in my decisions"
- "I want to avoid looking incompetent in front of my boss"
- "I want to feel in control of my workload"
- "I want to reduce anxiety about missing deadlines"
- "I want to feel proud when presenting results"

**Questions pour identifier** :
- Comment se sentent-ils actuellement sur cette situation ?
- Comment veulent-ils se sentir après ?
- Quelles émotions négatives veulent-ils éviter ?
- Quel soulagement cherchent-ils ?

### 3. Social Job (Comment Ils Veulent Être Perçus)

Comment ils veulent que les autres les voient.

**Exemples** :
- "I want to be seen as innovative by my peers"
- "I want my boss to see me as data-driven"
- "I want my team to respect my leadership"
- "I want clients to view me as professional"
- "I want to be recognized as an early adopter"

**Questions pour identifier** :
- Qui doit les voir différemment ?
- Quelle impression veulent-ils donner ?
- Quel statut social cherchent-ils ?
- De quelle tribu veulent-ils faire partie ?

## JTBD Research Questions

**Questions d'Exploration** :

1. **Situation & Context**
   - "Tell me about the last time you needed to [do job]"
   - "Walk me through what happened"
   - "What triggered you to start looking for a solution?"

2. **Current Approach**
   - "How are you solving this today?"
   - "What tools/methods are you using?"
   - "What workarounds have you created?"

3. **Alternatives Considered**
   - "What else have you tried before?"
   - "Why didn't those work?"
   - "What made you switch/stop using them?"

4. **Decision Criteria**
   - "What would make you switch to a new solution?"
   - "What holds you back from switching?"
   - "What would have to be true for you to change?"

5. **Success Metrics**
   - "How will you know if this worked?"
   - "What would success look like?"
   - "How do you measure progress?"

## Functional vs Emotional vs Social Balance

**Pattern 1: High Functional, Low Emotional/Social**
- Exemples : Outils techniques, developer tools, automation
- Messaging : Features, performance, efficiency
- Acheteurs : Analytiques, pragmatiques

**Pattern 2: Balanced Functional + Emotional**
- Exemples : Productivity tools, project management, CRM
- Messaging : Results + peace of mind
- Acheteurs : Managers, entrepreneurs

**Pattern 3: High Emotional/Social, Lower Functional**
- Exemples : Luxury goods, status products, community platforms
- Messaging : Identity, belonging, status
- Acheteurs : Aspirationnels, community-driven

## Exemples Complets par Persona

### Marketing Manager Maya (B2B SaaS)

**Functional Job**:
"I need to automate email marketing campaigns and track their performance"

**Emotional Job**:
"I want to feel confident when presenting ROI to my CEO"

**Social Job**:
"I want my CEO to see me as data-driven and strategic"

**JTBD Statement**:
"When launching new campaigns, I want to automate repetitive tasks and prove ROI, so I can focus on strategy and get executive buy-in."

**Alternative Solutions They've Tried**:
- Mailchimp (too basic, no advanced analytics)
- HubSpot (too expensive, overkill for team size)
- Manual processes (Excel + Gmail - error-prone, time-consuming)

**What Would Make Them Switch**:
- Built-in attribution tracking
- Free trial to prove ROI before commitment
- Simple enough to use without training
- Powerful enough for complex campaigns

### Busy Mom Brittany (E-commerce)

**Functional Job**:
"I need to find quality products for my kids quickly"

**Emotional Job**:
"I want to avoid the anxiety of making wrong purchase decisions"

**Social Job**:
"I want other moms to see me as a smart shopper who finds great deals"

**JTBD Statement**:
"When shopping for my kids online, I want clear product information and verified reviews, so I can make confident purchase decisions quickly and not waste money on low-quality items."

**Alternative Solutions They've Tried**:
- Amazon (overwhelming choices, fake reviews)
- Target in-store (time-consuming, kids meltdown)
- Mom Facebook groups (inconsistent advice)

**What Would Make Them Switch**:
- Curated product selections (fewer but better choices)
- Verified mom reviews (not fake)
- Free returns (reduces purchase anxiety)
- Mobile-optimized (shop during kids' activities)

## Mapping JTBD to Product Features

### Step 1: Identify All Jobs

List all jobs customers are trying to accomplish with your product category.

### Step 2: Prioritize Jobs

Rank by:
- Importance (how critical is this job?)
- Satisfaction (how well are current solutions working?)
- Frequency (how often do they need to do this job?)

**Formula**: `Opportunity Score = Importance + (Importance - Satisfaction)`

### Step 3: Design Features for High-Opportunity Jobs

Focus product development on jobs with high importance but low satisfaction.

### Step 4: Craft Messaging Around Jobs

Don't talk about features - talk about jobs accomplished.

❌ "Our tool has 50+ integrations"
✅ "Connect all your tools in one place so you can stop switching between apps"

## Common JTBD Mistakes

**Mistake 1: Confusing Job with Solution**
- ❌ "Customers hire us to use our CRM"
- ✅ "Customers hire us to manage customer relationships and never lose a lead"

**Mistake 2: Too Narrow (Product-Specific)**
- ❌ "Customers hire our app to click the send button"
- ✅ "Customers hire our app to communicate with their team instantly"

**Mistake 3: Too Broad (Meaningless)**
- ❌ "Customers hire us to be successful"
- ✅ "Customers hire us to close more deals by tracking follow-ups"

**Mistake 4: Missing the "When" (Situation)**
- ❌ "I want to save time"
- ✅ "When preparing for client meetings, I want to quickly find past conversations, so I can look informed"

## Using JTBD for Competitive Analysis

**Your competitors aren't just similar products - they're all solutions for the same job.**

### Example: Ride-Sharing JTBD

**Job**: "Get from A to B reliably and comfortably"

**Competitors**:
- Direct: Uber, Lyft
- Indirect: Personal car, public transport, bike-sharing, walking
- Creative: Moving closer to work, remote work

### Competitive Questions

1. What job are customers really hiring us to do?
2. What other ways are they accomplishing this job?
3. What can we learn from non-obvious competitors?
4. What job dimensions are underserved?

## Integration with Personas

**Connect JTBD to each persona segment:**

| Persona | Primary Functional Job | Primary Emotional Job | Primary Social Job |
|---------|----------------------|---------------------|-------------------|
| Marketing Manager Maya | Automate campaigns | Feel confident in decisions | Be seen as strategic |
| Busy Mom Brittany | Find quality products | Avoid purchase anxiety | Be seen as smart shopper |
| CTO Chris | Ensure system uptime | Reduce stress about outages | Be seen as reliable |

Each persona may hire your product for different jobs - tailor messaging accordingly.
