# デジタル庁イラスト・アイコンガイドライン詳細

## イラストレーションガイドライン

### イラストの種類

#### イラスト大

- **用途**: サービスや手続きの全体像を抽象的に伝えるイメージ画像
- **推奨配置**: ウェブのTOPページ、アプリ紹介画面
- **特徴**: サービス全体の雰囲気やコンセプトを視覚的に表現

#### イラスト中

- **用途**: 具体的なアクション（手続きなど）を表現する説明画像
- **推奨配置**: ウェブサイトの解説セクション
- **特徴**: より具体的な操作や状況を描写

#### イラスト小

- **用途**: 各イラストのパーツを取り出したエレメント
- **特徴**: 組み替えてカスタマイズが可能

### 利用上の注意

#### 変形禁止

イラストを歪ませたり、縦横比を変更したりしないでください。

#### 視認性の確保

内容が判読できる適切なサイズで掲示してください。

#### 代替テキスト（必須）

スクリーンリーダー利用者のため、`alt`属性に適切な代替テキストを設定してください。

**例:**

```html
<img src="..." alt="女性が役所のカウンターでマイナンバーカードを受け取っているイラスト">
```

## アイコンガイドライン

### アイコンの種類

#### サービスアイコン

- **用途**: 各サービスやコンテンツを特定・説明する目的
- **例**: 申請、照会、マイナンバー、医療など

#### システムアイコン

- **用途**: ウェブサービスやアプリ上で機能を表す
- **例**: 検索、メニュー、閉じる、ダウンロードなど

### 推奨される外部ソース

デジタル庁のアイコンで不足する場合:

- **Web / Android**: Material Symbols (Weight 300を推奨)
- **iOS**: SF Symbols

### 実装上の注意

#### ラベルの併用（推奨）

アイコン単体ではなく、テキストラベルとセットで使うことで理解を早めます。

#### アクセシビリティ配慮

- 色だけで状態（アクティブなど）を判断させない
- 形状の変化やラベルを工夫する

#### データ形式

軽さと綺麗さを保つため、**SVGなどのベクターデータ**での実装を推奨。

#### 禁止事項

- 縦横比の変更
- 不適切な回転
