# ライセンスと利用規約詳細

## 著作権と利用範囲

### 著作権

原則としてデジタル庁に帰属します。

### 利用の自由

複製、公衆送信、翻訳・変形などの翻案を、**商用・非商用問わず自由に行えます**。

### 同意

アセットを利用した時点で、本規約に同意したものとみなされます。

## 出典の記載ルール

### 原則

出典やクレジットの表記は**不要**です。

### 編集・加工する場合

#### 重要な制限

国（または府省等）が作成したかのような誤解を与える態様での公表は**禁止**されています。

#### 必須事項

出典と共に、編集・加工した内容を明示する必要があります。

#### 記載例テンプレート

```
「イラストレーション・アイコン素材」（デジタル庁）
（https://www.digital.go.jp/policies/servicedesign/designsystem/）を元に、
〇〇を独自に追加して提供しています
```

### 実装例

#### そのまま使用する場合（出典不要）

```tsx
<Image
  src="/icon/search.svg"
  alt="検索"
  width={24}
  height={24}
/>
```

#### 編集・加工した場合（出典必須）

```tsx
export function CustomizedIllustration() {
  return (
    <div>
      <Image
        src="/custom/modified-illustration.svg"
        alt="カスタマイズされたサービス説明イラスト"
        width={600}
        height={400}
      />
      <p className="text-xs text-gray-500">
        「イラストレーション・アイコン素材」（デジタル庁）
        （https://www.digital.go.jp/policies/servicedesign/designsystem/）を元に、
        当社サービスに合わせて独自に編集して提供しています
      </p>
    </div>
  );
}
```

## その他

### 準拠法

日本法に基づき、東京地方裁判所を専属的合意管轄裁判所とします。

### 免責

国は利用者がアセットを用いて行う一切の行為について責任を負いません。
