# LexiClash Translation Glossary

Key terms and their translations across all supported languages. Use this as a reference when writing new copy or translating existing text.

## Core Game Terms

| English | Spanish | Hebrew | Japanese | Swedish |
|---------|---------|--------|----------|---------|
| word | palabra | מילה | 単語 | ord |
| letter | letra | אות | 文字 | bokstav |
| score | puntuación | ניקוד | スコア | poäng |
| points | puntos | נקודות | ポイント | poäng |
| combo | combo | קומבו | コンボ | kombo |
| streak | racha | רצף | ストリーク | svit |
| leaderboard | tabla de líderes | טבלת מובילים | リーダーボード | topplista |
| rank | rango | דירוג | ランク | rankning |

## Game Modes

| English | Spanish | Hebrew | Japanese | Swedish |
|---------|---------|--------|----------|---------|
| Single Player | Un Jugador | שחקן יחיד | シングルプレイヤー | Enspelarläge |
| Multiplayer | Multijugador | מרובה משתתפים | マルチプレイヤー | Flerspelarläge |
| Daily Challenge | Desafío Diario | אתגר יומי | デイリーチャレンジ | Daglig utmaning |
| Word Hunt | Caza de Palabras | ציד מילים | ワードハント | Ordjakt |

## Actions

| English | Spanish | Hebrew | Japanese | Swedish |
|---------|---------|--------|----------|---------|
| Play | Jugar | שחק | プレイ | Spela |
| Start | Comenzar | התחל | スタート | Starta |
| Share | Compartir | שתף | 共有 | Dela |
| Copy | Copiar | העתק | コピー | Kopiera |
| Join | Unirse | הצטרף | 参加 | Gå med |
| Create | Crear | צור | 作成 | Skapa |
| Invite | Invitar | הזמן | 招待 | Bjud in |

## Results & Achievements

| English | Spanish | Hebrew | Japanese | Swedish |
|---------|---------|--------|----------|---------|
| Victory | Victoria | ניצחון | 勝利 | Seger |
| Win | Victoria | ניצחון | 勝ち | Vinst |
| Lost | Perdido | הפסד | 負け | Förlorade |
| Achievement | Logro | הישג | 実績 | Prestation |
| Unlocked | Desbloqueado | פתוח | アンロック | Upplåst |
| Found | Encontrado | נמצא | 発見 | Hittade |

## UI Labels

| English | Spanish | Hebrew | Japanese | Swedish |
|---------|---------|--------|----------|---------|
| Loading... | Cargando... | טוען... | 読み込み中... | Laddar... |
| Settings | Configuración | הגדרות | 設定 | Inställningar |
| Profile | Perfil | פרופיל | プロフィール | Profil |
| Home | Inicio | בית | ホーム | Hem |
| Back | Atrás | חזרה | 戻る | Tillbaka |
| Close | Cerrar | סגור | 閉じる | Stäng |

## Common Phrases

### Encouragement

| English | Spanish | Hebrew | Japanese | Swedish |
|---------|---------|--------|----------|---------|
| Nice! | ¡Genial! | יפה! | ナイス！ | Snyggt! |
| Great job! | ¡Buen trabajo! | עבודה מצוינת! | よくやった！ | Bra jobbat! |
| Keep going! | ¡Sigue así! | המשך! | 続けて！ | Fortsätt! |
| Almost there! | ¡Casi lo logras! | כמעט! | あと少し！ | Nästan där! |

### Errors

| English | Spanish | Hebrew | Japanese | Swedish |
|---------|---------|--------|----------|---------|
| Already found! | ¡Ya encontrado! | כבר נמצא! | 既に発見済み！ | Redan hittad! |
| Not on board! | ¡No está en el tablero! | לא על הלוח! | ボードにない！ | Finns inte på brädet! |
| Too short! | ¡Muy corto! | קצר מדי! | 短すぎる！ | För kort! |

### Sharing

| English | Spanish | Hebrew | Japanese | Swedish |
|---------|---------|--------|----------|---------|
| Share your score | Comparte tu puntuación | שתף את הניקוד | スコアをシェア | Dela din poäng |
| Challenge friends | Desafía a amigos | אתגר חברים | 友達に挑戦 | Utmana vänner |
| Can you beat this? | ¿Puedes superarlo? | תוכל לנצח? | 勝てますか？ | Kan du slå detta? |

## Achievement Names

Achievement names should be creative and memorable. Here are the current ones:

| Key | English | Description |
|-----|---------|-------------|
| FIRST_BLOOD | First Blood | First valid word |
| SPEED_DEMON | Speed Demon | Fast word finding |
| WORD_MASTER | Word Master | 7+ letter word |
| COMBO_KING | Combo King | High combo streak |
| TREASURE_HUNTER | Treasure Hunter | 8+ letter word |
| RARE_GEM | Rare Gem | 9+ letter word |
| QUICK_THINKER | Quick Thinker | Word in first seconds |
| WORDSMITH | Wordsmith | 50 valid words |
| LEXICON | Lexicon | 65+ valid words |
| UNSTOPPABLE | Unstoppable | 75+ valid words |
| STREAK_MASTER | Streak Master | 30+ combo |
| COMEBACK_KID | Comeback Kid | Word in final seconds |
| VOCABULARY_TITAN | Vocabulary Titan | 85+ words |
| SPEED_LEGEND | Speed Legend | 50 words in first half |

## Emoji Usage by Language

Emojis are universal, but placement matters:

- **English/Spanish/Swedish**: Emoji before or after text
- **Hebrew**: Emoji at END of text (appears on left in RTL)
- **Japanese**: Emoji after text, integrated naturally

## Translation Tips

1. **Don't translate literally** - Adapt the meaning, not the words
2. **Keep the energy** - If English is excited, translation should be too
3. **Match character count** - UI space is limited
4. **Test in context** - Read the translated text where it appears
5. **Ask native speakers** - When in doubt, verify with native speakers
