---
name: Vendor Manager
slug: vendor-manager
description: Manage vendor relationships, track performance, negotiate contracts, and optimize procurement
category: business
complexity: complex
version: "1.0.0"
author: "ID8Labs"
triggers:
  - "vendor management"
  - "supplier management"
  - "vendor performance"
  - "contract management"
  - "procurement"
  - "vendor scorecard"
tags:
  - vendors
  - procurement
  - contracts
  - supply-chain
  - business-operations
---

# Vendor Manager

Expert vendor and supplier management system that helps you evaluate vendors, manage contracts, track performance, negotiate terms, and optimize procurement. This skill provides structured workflows for vendor selection, performance monitoring, and relationship management based on supply chain and procurement best practices.

Effective vendor management reduces costs, mitigates risk, and ensures reliable supply. This skill helps you build strategic vendor relationships, hold suppliers accountable to performance standards, and make data-driven sourcing decisions. Whether you're managing a handful of key suppliers or a complex vendor network, this provides the framework for operational excellence.

Built on procurement best practices and strategic sourcing principles, this skill combines vendor evaluation, performance scorecards, and contract management to optimize your supply base.

## Core Workflows

### Workflow 1: Vendor Qualification & Selection
**Evaluate and onboard new vendors strategically**

1. **Vendor Discovery**
   - Define requirements: product/service specs, volume, quality standards
   - Source candidates:
     - Industry directories and trade shows
     - Referrals from peers and partners
     - Online searches and marketplaces
     - RFI (Request for Information) campaigns
   - Create long-list (10-15 potential vendors)

2. **Initial Assessment**
   - **Capability**: Can they meet our requirements?
   - **Capacity**: Can they handle our volume (current and future)?
   - **Financial Stability**: Are they financially sound? (D&B rating, financials)
   - **Reputation**: What do other customers say? (references, reviews)
   - **Compliance**: Do they meet regulatory/certification requirements?
   - **Geographic**: Location advantages/risks (proximity, time zones, geopolitics)
   - Narrow to short-list (3-5 vendors)

3. **RFP/RFQ Process**
   - **RFQ (Request for Quote)**: For standardized products (price-focused)
   - **RFP (Request for Proposal)**: For complex services (solution-focused)
   - Include in RFP/RFQ:
     - Detailed requirements and specifications
     - Volume projections and timelines
     - Quality standards and testing requirements
     - Payment terms and pricing structure
     - Delivery and logistics expectations
     - SLA requirements (response time, uptime, etc.)

4. **Vendor Evaluation Matrix**
   Score each vendor on key criteria (weight by importance):
   - **Price (30%)**: Total cost of ownership, not just unit price
   - **Quality (25%)**: Defect rates, certifications, testing processes
   - **Delivery (20%)**: Lead time, on-time delivery %, flexibility
   - **Service (15%)**: Responsiveness, support, communication
   - **Innovation (10%)**: Continuous improvement, technology, R&D
   - Calculate weighted score, select top vendor(s)

5. **Due Diligence & Onboarding**
   - Check references from current customers
   - Visit facility if critical vendor (audit capabilities)
   - Review insurance and certifications
   - Negotiate contract (see Workflow 2)
   - Set up in procurement/accounting systems
   - Assign vendor owner/relationship manager

### Workflow 2: Contract Negotiation & Management
**Structure vendor agreements to protect interests and drive performance**

1. **Contract Terms to Negotiate**
   - **Pricing**: Unit price, volume discounts, price lock periods, escalation clauses
   - **Payment Terms**: Net 30/60/90, early payment discounts, payment methods
   - **Lead Times**: Standard delivery time, expedite options, penalties for delays
   - **Minimum Order Quantities (MOQ)**: Lower MOQ, flexibility for trials
   - **Quality Standards**: Acceptance criteria, return/replacement policy, warranties
   - **Service Levels (SLA)**: Uptime guarantees, response times, performance penalties
   - **Termination**: Notice period, termination for cause, transition assistance
   - **Liability**: Indemnification, liability caps, insurance requirements
   - **Intellectual Property**: Ownership of work product, confidentiality (NDA)

2. **Negotiation Strategy**
   - Research market rates (benchmark pricing)
   - Understand vendor's position (are you a key customer or small fish?)
   - Leverage competitive bids (use multiple proposals)
   - Focus on total value, not just price (quality, service, terms)
   - Build long-term relationship, not one-off wins
   - Document all agreed terms in writing

3. **Contract Tracking**
   - Centralized contract repository (searchable, version-controlled)
   - Track key dates:
     - Contract start/end dates
     - Auto-renewal dates (cancel 90 days prior if needed)
     - Price review/escalation dates
     - Performance review milestones
   - Set reminders for renewals and renegotiations
   - Monitor contract compliance (are terms being met?)

4. **Contract Renewal Process**
   - Review performance 90 days before renewal
   - Benchmark current pricing vs. market
   - Decide: Renew, renegotiate, or re-bid
   - If renewing: Negotiate improvements (better terms, pricing, SLA)
   - If replacing: Follow vendor selection process (Workflow 1)

### Workflow 3: Vendor Performance Monitoring
**Track vendor performance with objective scorecards**

1. **Scorecard Metrics**
   Design scorecard based on what matters most (weight by importance):

   **Quality (30%):**
   - Defect rate (defects per 1,000 units)
   - First-pass acceptance rate
   - Customer complaint rate attributed to vendor
   - Certifications maintained

   **Delivery (30%):**
   - On-time delivery rate (% delivered by promised date)
   - Complete order fill rate (% shipped complete)
   - Average lead time vs. promised
   - Flexibility to expedite/adjust orders

   **Cost (20%):**
   - Price competitiveness (vs. market benchmarks)
   - Total cost of ownership (price + shipping + quality issues + admin)
   - Invoice accuracy (billing errors)
   - Cost improvement initiatives

   **Service (20%):**
   - Responsiveness (time to respond to inquiries)
   - Issue resolution time
   - Communication quality
   - Proactivity and innovation

2. **Data Collection**
   - Automate where possible (delivery data from WMS, quality data from QC)
   - Manual tracking for subjective metrics (communication quality)
   - Collect data continuously, score monthly/quarterly
   - Maintain audit trail and evidence

3. **Scoring & Rating**
   - Use 1-5 scale or 0-100 score for each metric
   - Weight by importance, calculate overall score
   - Rate vendors: Preferred (90+), Approved (70-89), Probation (50-69), Disqualified (<50)
   - Rank vendors within category for comparative view

4. **Performance Reviews**
   - **Monthly**: Internal review of scorecard data
   - **Quarterly**: Formal review with vendor (QBR - Quarterly Business Review)
     - Share scorecard results
     - Discuss issues and improvement plans
     - Recognize strong performance
     - Set goals for next quarter
   - **Annual**: Strategic review, contract renewal decision

### Workflow 4: Vendor Relationship Management
**Build strategic partnerships and optimize collaboration**

1. **Vendor Segmentation**
   - **Strategic Partners**: High spend, high risk, long-term partnership
     - Executive sponsor relationship
     - Quarterly business reviews
     - Joint innovation and planning
     - Preferred pricing and priority service

   - **Preferred Vendors**: Solid performers, moderate spend
     - Assigned relationship manager
     - Semi-annual reviews
     - Standard contract terms
     - Competitive pricing

   - **Transactional Vendors**: Low spend, commodity products
     - Minimal management overhead
     - Order-based relationship
     - Competitive bidding for renewals

2. **Communication Cadence**
   - **Daily/Weekly**: Operational communication (orders, shipments, issues)
   - **Monthly**: Scorecard review and issue resolution (for key vendors)
   - **Quarterly**: QBR with strategic vendors (performance, roadmap, opportunities)
   - **Annual**: Contract renewal, strategic planning

3. **Issue Escalation**
   - **Level 1 (Day-to-day)**: Procurement/operations team resolves
   - **Level 2 (Service failures)**: Relationship manager escalates to vendor manager
   - **Level 3 (Repeated failures)**: Executive escalation, performance improvement plan
   - **Level 4 (Breach of contract)**: Legal involvement, potential termination

4. **Vendor Development**
   - Share forecasts and business plans (help them plan)
   - Provide feedback on quality issues (enable improvement)
   - Collaborate on cost reduction initiatives (mutual benefit)
   - Pilot new products/services together (innovation)
   - Recognize top performers (awards, increased business)

### Workflow 5: Risk Management & Continuity
**Mitigate supply chain risks and ensure business continuity**

1. **Risk Identification**
   - **Concentration Risk**: Over-reliance on single vendor
   - **Financial Risk**: Vendor bankruptcy or financial distress
   - **Operational Risk**: Quality issues, delivery failures, capacity constraints
   - **Geopolitical Risk**: Trade wars, sanctions, political instability
   - **Cybersecurity Risk**: Data breaches, IP theft
   - **Natural Disaster**: Facility damage, supply disruption

2. **Risk Mitigation Strategies**
   - **Dual Sourcing**: Maintain backup vendors for critical items (20/80 split)
   - **Safety Stock**: Higher inventory buffers for risky vendors
   - **Contract Protections**: Performance bonds, insurance requirements, termination rights
   - **Financial Monitoring**: Review financials annually, subscribe to D&B alerts
   - **Geographic Diversification**: Avoid single-region concentration
   - **Vendor Audits**: Periodic facility audits for critical vendors

3. **Business Continuity Planning**
   - Identify single points of failure in supply base
   - Develop contingency plans for top risks
   - Pre-qualify backup vendors (ready to activate)
   - Test failover scenarios periodically
   - Maintain emergency contact lists

4. **Issue Response**
   - When vendor failure occurs:
     - Assess impact and urgency
     - Activate contingency plan (backup vendor, safety stock)
     - Communicate with stakeholders (internal teams, customers)
     - Work with vendor on resolution (if recoverable)
     - Document lessons learned, adjust risk plan

## Quick Reference

| Action | Command/Trigger |
|--------|-----------------|
| Add new vendor | "Onboard vendor: [Name]" |
| Vendor scorecard | "Show performance for [Vendor]" |
| Contract renewal | "List contracts expiring next 90 days" |
| Top vendors | "Show top 10 vendors by spend" |
| Vendor comparison | "Compare [Vendor A] vs [Vendor B]" |
| Issue tracking | "Log vendor issue: [Description]" |
| Payment terms | "Show payment terms for [Vendor]" |
| Performance trend | "Show [Vendor] trend last 12 months" |
| Audit checklist | "Create vendor audit plan for [Vendor]" |
| RFP generation | "Generate RFP for [Category]" |

## Best Practices

### Vendor Selection
- Always get multiple quotes (minimum 3 for competitive pricing)
- Evaluate total cost of ownership, not just unit price
- Check references from current customers
- Visit critical vendors' facilities before contract
- Start with trial/pilot period when possible

### Contract Management
- Standardize contract templates (legal review once, reuse)
- Track all contracts in central system
- Set calendar reminders for renewals (90 days in advance)
- Never let contracts auto-renew without review
- Document all amendments in writing

### Performance Tracking
- Automate data collection where possible (reduce manual work)
- Use objective metrics (not just feelings)
- Share scorecard with vendors (transparency builds trust)
- Focus on trends, not single bad months
- Tie scorecard to business outcomes (preferred status, volume allocation)

### Relationship Building
- Treat vendors as partners, not adversaries
- Share forecasts and plans (help them help you)
- Pay on time (builds goodwill and negotiating leverage)
- Provide constructive feedback (enable improvement)
- Recognize strong performance publicly

### Risk Management
- Never rely on single vendor for critical items
- Monitor vendor financial health (D&B ratings, news)
- Maintain backup vendor relationships (warm standby)
- Build inventory buffers for high-risk vendors
- Diversify geographically when feasible

## Key Metrics to Track

**Spend Metrics:**
- Total vendor spend (annual)
- Spend by vendor (concentration analysis)
- Spend by category
- Spend under contract vs. off-contract (maverick spend)
- Cost savings from negotiations

**Performance Metrics:**
- On-time delivery rate (target: 95%+)
- Quality/defect rate (target: <0.5%)
- Invoice accuracy rate (target: 98%+)
- Average lead time by vendor
- Overall vendor scorecard scores

**Contract Metrics:**
- Number of active vendors
- Contract coverage (% of spend under contract)
- Contract compliance rate
- Average contract term length
- Contracts up for renewal (next 90 days)

**Risk Metrics:**
- Vendor concentration (% spend with top vendor/top 3/top 10)
- Single-source dependencies (critical items with one vendor)
- Vendors on probation or watch list
- Vendor turnover rate (churn)

## Common Pitfalls to Avoid

- **Price obsession**: Choosing cheapest vendor, ignoring quality/service
- **Single sourcing**: Over-reliance on one vendor creates vulnerability
- **Auto-renewals**: Letting contracts renew without performance review
- **Poor documentation**: Handshake deals, verbal agreements (no recourse)
- **No scorecards**: Managing by gut feel, not data
- **Vendor sprawl**: Too many vendors increases complexity and reduces leverage
- **Ignoring red flags**: Financial trouble, quality issues, delivery failures
- **Lack of backups**: No contingency when primary vendor fails

## Vendor Scorecard Template

| Category | Metric | Weight | Score (1-5) | Weighted |
|----------|--------|--------|-------------|----------|
| **Quality** | | 30% | | |
| - Defect rate | <0.5% defects | 15% | 4 | 0.60 |
| - Certifications | ISO 9001 current | 10% | 5 | 0.50 |
| - Returns | <1% return rate | 5% | 4 | 0.20 |
| **Delivery** | | 30% | | |
| - On-time % | >95% on-time | 20% | 4 | 0.80 |
| - Lead time | Meets committed | 10% | 5 | 0.50 |
| **Cost** | | 20% | | |
| - Price competitiveness | Market benchmark | 15% | 3 | 0.45 |
| - Invoice accuracy | >98% accurate | 5% | 5 | 0.25 |
| **Service** | | 20% | | |
| - Responsiveness | <24hr response | 10% | 4 | 0.40 |
| - Issue resolution | <7 days to resolve | 10% | 4 | 0.40 |
| **TOTAL** | | **100%** | | **4.10** |

**Rating:** 4.10/5.00 = 82% = Approved Vendor

**Ratings Key:**
- Preferred: 90-100% (4.5-5.0)
- Approved: 70-89% (3.5-4.4)
- Probation: 50-69% (2.5-3.4)
- Disqualified: <50% (<2.5)
