---
name: verify-content
description: 文章の事実確認と参照検証を行う統合スキル。主張の洗い出し、外部ソースでの検証、参考文献の整備までを一貫して実行。文書レビュー、記事校正、レポート確認、学術論文チェック時に使用。
---

# コンテンツ検証スキル

文章の信頼性を確保するための統合ワークフローを提供します。

## ワークフロー概要

```
┌─────────────┐    ┌─────────────┐    ┌─────────────┐
│  Step 1     │    │  Step 2     │    │  Step 3     │
│  洗い出し   │ → │  検証       │ → │  参照整備   │
│  (scan)     │    │  (verify)   │    │  (reference)│
└─────────────┘    └─────────────┘    └─────────────┘
```

各ステップの詳細は以下のファイルを参照：
- [scan.md](scan.md) - 検証対象箇所の洗い出し
- [verify.md](verify.md) - 外部ソースでの事実確認
- [reference.md](reference.md) - 参考文献リストと相互参照の整備

## クイックスタート

### 全体フローを実行する場合

```
ユーザー: このドキュメントの内容を検証して
```

### 特定ステップのみ実行する場合

```
ユーザー: この記事で検証が必要な箇所を洗い出して
ユーザー: この数値データをファクトチェックして
ユーザー: 参考文献リストを整備して
```

## Step 1: 洗い出し（scan）

文章全体を分析し、検証が必要な箇所を特定します。

### チェック観点

| カテゴリ | 対象例 |
|----------|--------|
| 事実の記述 | 歴史的事実、科学的事実、制度・法律 |
| 定量的な文言 | 数値、統計、日時、順位 |
| 断定的な表現 | 「必ず」「唯一の」「最大の」 |
| 引用・参照 | 人物の発言、文献からの引用 |
| 比較・評価 | 「より優れている」「一般的に」 |

### 出力形式

```markdown
## 検証対象箇所

### 優先度: 高
| # | 該当箇所 | 種別 | 確認内容 |
|---|----------|------|----------|
| 1 | 「...」 | 数値 | 出典確認 |
```

詳細は [scan.md](scan.md) を参照。

## Step 2: 検証（verify）

特定された箇所について、外部ソースで事実確認を行います。

### 検証プロセス

1. **情報源の特定**: ウェブ検索で候補を収集
2. **実際のコンテンツ取得**: WebFetch または curl で確認
3. **判定**: 一致性、正確性、文脈、最新性をチェック

### 重要: AI検索結果を鵜呑みにしない

```bash
# WebFetchがブロックされる場合
curl -s -L "https://example.com/page" | head -200

# Wayback Machineで過去版を確認
curl -s "https://archive.org/wayback/available?url=example.com/page"
```

### 判定基準

| 判定 | 条件 |
|------|------|
| ✅ 正確 | 信頼性の高い情報源で確認、内容一致 |
| ⚠️ 要修正 | おおむね正確だが細部に修正必要 |
| ❌ 誤り | 事実と異なる、重大な誤解を招く |
| ❓ 確認不可 | 信頼できる情報源が見つからない |

詳細は [verify.md](verify.md) を参照。

## Step 3: 参照整備（reference）

検証完了後、プロジェクト仕様に従い参考文献を整備します。

### 作業内容

1. **プロジェクト仕様の確認**: 引用スタイル、配置場所
2. **参考文献リストへの登録**: 確認できた情報源を追加
3. **本文中への相互参照の追加**: 脚注/インライン/番号参照

### 参照形式の例

```markdown
<!-- 脚注形式 -->
日本の人口は約1億2000万人である[^1]。
[^1]: 総務省統計局「人口推計」2024年

<!-- インライン形式 -->
日本の人口は約1億2000万人である（総務省統計局, 2024）。
```

詳細は [reference.md](reference.md) を参照。

## 既存の参照・引用の検証

文章に既に参考文献がある場合は、以下も確認します：

### チェック項目

- [ ] リンクが生きているか（404エラーなし）
- [ ] 引用内容が参照先と一致しているか
- [ ] 引用が文脈に沿って使われているか
- [ ] 参照先の情報が最新か

### リンク切れ対応

```bash
# ステータスコード確認
curl -s -o /dev/null -w "%{http_code}" "https://example.com/page"

# Wayback Machineで代替URL取得
curl -s "https://archive.org/wayback/available?url=example.com/page"
```

## 使用例

```
ユーザー: README.mdの内容を検証して参考文献を整備して
```

```
ユーザー: この論文の引用が正しいか確認して
```

```
ユーザー: Issue #45 で洗い出された項目を検証して
```

## 出力レポート形式

```markdown
# コンテンツ検証レポート

## 対象ファイル
- path/to/document.md

## 検証サマリー
| 項目数 | ✅ 正確 | ⚠️ 要修正 | ❌ 誤り | ❓ 確認不可 |
|--------|---------|-----------|---------|-------------|
| 10     | 7       | 2         | 0       | 1           |

## 詳細結果
[各項目の検証結果...]

## 参照整備状況
- [ ] 参考文献リスト更新済み
- [ ] 本文中相互参照追加済み
- [ ] リンク動作確認済み
```
