# 参考文献の整備（Reference）

検証完了後、参考文献が明らかになった項目について、プロジェクトの仕様に従い適切な事後作業を行います。

## 作業フロー

### Step 1: プロジェクト仕様の確認

まず対象ドキュメントやプロジェクトの参考文献管理ルールを確認：

- 参考文献リストの形式（書式、配置場所）
- 相互参照の記法（脚注、インライン、番号参照など）
- 引用スタイル（APA、IEEE、独自形式など）

### Step 2: 参考文献リストへの登録

確認できた情報源を参考文献リストに追加：

```markdown
## 参考文献

1. [タイトル](URL) - 著者/組織名, 公開日/アクセス日
2. 書籍名, 著者, 出版社, 出版年, ページ
```

### Step 3: 本文中への相互参照の追加

本文中の該当箇所に参照を追加：

```markdown
<!-- 脚注形式 -->
日本の人口は約1億2000万人である[^1]。

[^1]: 総務省統計局「人口推計」2024年

<!-- インライン形式 -->
日本の人口は約1億2000万人である（総務省統計局, 2024）。

<!-- 番号参照形式 -->
日本の人口は約1億2000万人である[1]。
```

### Step 4: 既存参照の更新

既存の参考文献で問題があった場合：

| 問題 | 対応 |
|------|------|
| リンク切れ | Wayback Machineの代替URLに更新、または注釈追加 |
| 内容不一致 | 正しい引用に修正、または該当箇所を削除 |
| 情報が古い | 最新版への更新、または「YYYY年時点」の注記追加 |

## 引用スタイル例

### APA形式
```
著者名 (年). タイトル. 出版社.
総務省統計局 (2024). 人口推計. https://www.stat.go.jp/...
```

### IEEE形式
```
[1] 著者名, "タイトル," 出版社, 年.
[1] 総務省統計局, "人口推計," 2024. [Online]. Available: https://...
```

### Markdown脚注形式
```markdown
本文中の記述[^1]。

[^1]: 出典情報
```

## チェックリスト

- [ ] 参考文献リストに情報源を追加した
- [ ] 本文中に相互参照を追加した
- [ ] 参照形式がプロジェクト仕様に準拠している
- [ ] リンクが正しく機能することを確認した
- [ ] アクセス日を記載した（ウェブ資料の場合）

## 注意事項

### ウェブ資料の場合
- アクセス日を必ず記載
- 可能であればWayback Machineのアーカイブリンクも併記
- PDFなど永続的なURLを優先

### 引用の妥当性
- 一次資料を優先（孫引きを避ける）
- 著作権に配慮（適切な引用の範囲内か）
- 引用箇所が文脈に沿っているか再確認

## 出力形式

```markdown
## 参照整備レポート

### 追加した参考文献
| # | 出典 | 本文中の参照箇所 |
|---|------|------------------|
| 1 | [総務省統計局](https://...) | 3行目「人口は...」 |

### 更新した参照
| # | 元の参照 | 更新内容 |
|---|----------|----------|
| 1 | [1] 旧URL | 新URLに更新 |

### 確認事項
- [x] 全リンク動作確認済み
- [x] 引用形式統一済み
```
