# 検証対象箇所の洗い出し（Scan）

文章全体を分析し、検証が必要な箇所を体系的に特定します。

## チェック観点

### 1. 事実の記述
- 歴史的事実（日付、出来事、人物）
- 科学的事実（法則、原理、現象）
- 地理的事実（場所、距離、位置関係）
- 制度・法律に関する記述

### 2. 定量的な文言
- 数値データ（統計、割合、金額）
- 日時・期間（年月日、期限、頻度）
- 順位・ランキング
- 比較数値（増減率、倍率）

### 3. 断定的な表現
- 「〜である」「〜だ」などの断定
- 「必ず」「絶対に」「常に」などの強調
- 「唯一の」「最初の」「最大の」などの最上級表現
- 因果関係の断定（「〜のため」「〜により」）

### 4. 引用・参照
- 人物の発言・コメント
- 文献・資料からの引用
- 調査・研究結果の参照
- 公式発表・声明

### 5. 比較・評価
- 他との比較（「より〜」「〜に比べて」）
- 評価・判断（「優れている」「問題がある」）
- 一般化（「多くの」「ほとんどの」「一般的に」）

### 6. 既存の参考文献・リンク
- 文中の参照記号（[1], [^1] など）
- URLリンク
- 脚注・注釈

## 出力形式

```markdown
## 検証対象箇所

### 優先度: 高
| # | 該当箇所 | 種別 | 確認内容 | 想定される参照先 |
|---|----------|------|----------|------------------|
| 1 | 「...」 | 数値データ | 出典と正確性 | 公式サイト、論文 |

### 優先度: 中
| # | 該当箇所 | 種別 | 確認内容 | 想定される参照先 |
|---|----------|------|----------|------------------|

### 優先度: 低
| # | 該当箇所 | 種別 | 確認内容 | 想定される参照先 |
|---|----------|------|----------|------------------|

### 既存参照のチェック
| # | 参照 | リンク/出典 | 確認内容 |
|---|------|-------------|----------|
| 1 | [1] | https://... | リンク生存、内容一致 |
```

## 優先度の判断基準

- **高**: 数値データ、引用、法的・制度的記述、読者の意思決定に影響する内容
- **中**: 一般的な事実記述、比較表現、歴史的事実
- **低**: 一般化表現、主観的評価、広く知られた事実

## 注意事項

- このステップは「洗い出し」のみを行います
- 実際の検証は [verify.md](verify.md) で行います
- 洗い出し結果はIssueやドキュメントとして保存することを推奨
