# 外部ソースでの検証（Verify）

特定された箇所について、信頼性の高い情報源を用いて事実確認を行います。

## 検証プロセス

### Step 1: 情報源の特定

1. ウェブ検索で関連情報を収集
2. 公式サイト、論文、信頼性の高いメディアを優先
3. 複数の独立した情報源を確保

### Step 2: 実際のコンテンツ取得と確認

**重要**: AI検索結果をそのまま信用せず、必ず実際のページ内容を確認してください。

#### WebFetchツールでの取得
```
WebFetch: URL から実際のコンテンツを取得
```

#### AIアクセス禁止サイトの場合
WebFetchがブロックされる場合は、CLIツールを使用：

```bash
# curlでページ取得
curl -s -L "https://example.com/page" | head -200

# User-Agentを指定する場合
curl -s -L -A "Mozilla/5.0" "https://example.com/page"

# HTMLをテキスト抽出（w3mがある場合）
curl -s -L "https://example.com/page" | w3m -dump -T text/html

# 特定の要素を抽出（grepと組み合わせ）
curl -s -L "https://example.com/page" | grep -A5 "keyword"
```

### Step 3: 検証と判定

各項目について以下を確認：

| 確認項目 | 内容 |
|----------|------|
| 一致性 | 元の記述と情報源の内容が一致するか |
| 正確性 | 数値や日付に誤りがないか |
| 文脈 | 引用が文脈に沿って使われているか |
| 最新性 | 情報が最新か（特に統計・制度） |

## 判定基準

| 判定 | 条件 |
|------|------|
| ✅ 正確 | 信頼性の高い情報源で確認でき、内容が一致 |
| ⚠️ 要修正 | おおむね正確だが、細部に修正が必要 |
| ❌ 誤り | 事実と異なる、または重大な誤解を招く |
| ❓ 確認不可 | 信頼できる情報源が見つからない、またはアクセス不可 |

## 出力形式

```markdown
### チェック項目 1: 「[該当箇所]」

**判定**: ✅ 正確 / ⚠️ 要修正 / ❌ 誤り / ❓ 確認不可

**検証内容**:
- 確認した情報源: [URL/文献名]
- 取得方法: WebFetch / curl
- 確認日: YYYY-MM-DD

**詳細**:
[情報源から得られた事実と、元の記述との比較]

**推奨アクション**:
[修正が必要な場合の具体的な提案]
```

## リンク切れ・誤認への対応

- URLが404の場合は、Wayback Machine (archive.org) で過去版を確認
- 類似URLへのリダイレクトに注意（内容が異なる可能性）
- ドメイン変更の可能性を考慮

```bash
# Wayback Machineでの確認
curl -s "https://archive.org/wayback/available?url=example.com/page"
```

## 情報源の信頼性評価

| レベル | 情報源の種類 | 扱い |
|--------|-------------|------|
| 高 | 公式発表、学術論文、政府統計 | 優先的に使用 |
| 中 | 主要メディア、専門家見解 | 複数で裏取り |
| 低 | 個人ブログ、SNS | 補助的に使用 |

## 検証できない場合

- 「確認不可」と明記
- 確認できなかった理由を記載
- 可能であれば代替の確認方法を提案
- 該当箇所の削除または注釈追加を検討
