# 悪い例：アンチパターン集

YouTube台本でよくある問題パターンと改善例。

---

## 1. 誇大表現の使用

### ❌ 悪い例

```
今回紹介するツールはマジでヤバいです。
神機能が満載で、最強のAIツールと言っても過言ではありません。
これを知らないと損ですよ。
```

**問題点:**
- 「ヤバい」「神」「最強」→ NGワード
- 「知らないと損」→ 煽り表現
- 具体性がない

### ✅ 良い例

```
今回紹介するツールは非常に便利です。
特に〇〇という機能が優れていて、
私も毎日の開発で活用しています。
ぜひ試してみてください。
```

---

## 2. 挨拶から始める

### ❌ 悪い例

```
はいどうもこんにちは、〇〇です。
今日も動画を見てくださりありがとうございます。
最近寒くなってきましたね。皆さんいかがお過ごしでしょうか。
さて、今日は〇〇についてお話ししていきたいと思います。
```

**問題点:**
- 本題まで時間がかかる
- 天気の話など無関係な内容
- 視聴者が離脱しやすい

### ✅ 良い例

```
Claude Codeで開発ルールを設定していると、
CLAUDE.mdが肥大化してしまうことはないでしょうか。
今回は動的なルール読み込み機能を使って
この問題を解決する方法をお伝えします。
```

---

## 3. 長すぎる文

### ❌ 悪い例

```
このツールはGoogleが開発したもので、AIが組み込まれていて、
Gemini 3 ProやClaude Sonnet 4.5などの複数のモデルが使えて、
しかも入力補完機能もあって、コマンド実行も無制限で、
個人利用なら無料という非常に多機能なエディターとなっています。
```

**問題点:**
- 1文が長すぎて息継ぎできない
- 情報が詰め込みすぎ
- 理解しづらい

### ✅ 良い例

```
このツールはGoogleが開発したエディターです。
AIが組み込まれていて、複数のモデルが使えます。
Gemini 3 ProやClaude Sonnet 4.5などですね。
入力補完やコマンド実行も無制限です。
しかも個人利用なら無料というのがうれしいところです。
```

---

## 4. 断定しすぎ

### ❌ 悪い例

```
この方法を使えば絶対に失敗しません。
誰でも簡単にできます。
5分で完璧なアプリが作れます。
```

**問題点:**
- 「絶対」「誰でも」「完璧」→ 過度な断定
- 視聴者の期待値を上げすぎ
- 信頼を損なう

### ✅ 良い例

```
この方法を使うとリスクを抑えられます。
基本的な手順に沿えば、30分程度で動くものが作れます。
私も最初は戸惑いましたが、コツを掴めば効率的に開発できるようになりました。
```

---

## 5. 段階的説明がない

### ❌ 悪い例

```
ではAPIを叩いていきます。
まずcurlでPOSTリクエストを送ります。
ヘッダーにContent-Typeを設定して、
ボディにJSONを入れます。
レスポンスが返ってきたら完了です。
```

**問題点:**
- 「API」「curl」「POST」などの用語説明がない
- 初心者が置いていかれる
- なぜその操作をするのか不明

### ✅ 良い例

```
ではAPIを呼び出してみましょう。
APIとは、ソフトウェア同士を繋ぐための仕組みです。
開発者の間では「APIを叩く」という言い方をします。

具体的にはcurlというコマンドを使います。
これはターミナルからHTTPリクエストを送るためのツールですね。

今回はPOSTリクエスト、つまりデータを送信する形式で
APIにアクセスしていきます。
```

---

## 6. リスク・注意点への言及がない

### ❌ 悪い例

```
APIキーを取得したら、コードに直接書いておきましょう。
これで自動化が完成です。
無料枠があるので気軽に試してみてください。
```

**問題点:**
- APIキーの管理について警告がない
- 費用リスクへの言及がない
- セキュリティ意識が低い

### ✅ 良い例

```
APIキーを取得したら、環境変数として設定しましょう。
コードに直接書くと、GitHubに公開した際に
第三者に悪用される可能性があります。

また、無料枠があるとはいえ、
使いすぎると費用が発生することがあります。
公式ドキュメントで上限を確認してから利用することをお勧めします。
```

---

## 7. CTAがない、または弱い

### ❌ 悪い例

```
以上です。ありがとうございました。
```

**問題点:**
- チャンネル登録・高評価の呼びかけがない
- 学びの活用促進がない
- あっさりしすぎ

### ✅ 良い例

```
ということで今日はClaude Codeの動的ルール機能についてお伝えしました。
コンテキスト管理はAI駆動開発で非常に重要な課題です。
ぜひ今回の学びを開発に生かしていただければと思います。

今日の動画が参考になったという方は
ぜひチャンネル登録と高評価で応援をお願いします。
それではまた次の動画でお会いしましょう。
ご視聴ありがとうございました。
```

---

## 8. 視聴者への配慮がない

### ❌ 悪い例

```
これ知らないんですか？常識ですよ。
こんな簡単なこともできないなら開発者失格ですね。
まあ見れば分かると思うんで説明省きますね。
```

**問題点:**
- 上から目線
- 視聴者を馬鹿にしている
- 説明を省略

### ✅ 良い例

```
ここは私も最初は分かりにくかったんですが、
こうやって考えると理解しやすいです。
もし分からない点があればコメントで教えてください。
できる限りお答えします。
```

---

## 9. 具体性がない

### ❌ 悪い例

```
このツールを使うとすごく便利になります。
いろいろなことができます。
効率がアップします。
```

**問題点:**
- 何が便利なのか不明
- 「いろいろ」では伝わらない
- 数字がない

### ✅ 良い例

```
このツールを使うと処理時間が3分の1になりました。
具体的には、毎朝9時に自動でSlackに通知を送る、
Googleカレンダーの予定を自動でNotionに転記する、
こういった自動化が簡単に設定できます。
```

---

## 10. 構成が不明確

### ❌ 悪い例

```
このツールについて話します。
まず機能Aがあります。で、機能Bもあって。
あ、そういえば機能Cも便利ですね。
話が戻りますが機能Aについてもう少し詳しく。
ちなみに料金は〜
```

**問題点:**
- 目次がない
- 話があちこちに飛ぶ
- 視聴者が迷子になる

### ✅ 良い例

```
今日は3つのポイントをお伝えします。
まず機能Aについて。
次に機能Bと機能Cの比較。
最後に料金体系です。

ではまず機能Aから見ていきましょう。
[...]
以上が機能Aについてでした。
次に機能BとCを比較していきます。
```

---

## チェックリスト

台本完成時に以下を確認:

- [ ] NGワードを使用していないか
- [ ] 挨拶なしでいきなり本題に入っているか
- [ ] 1文40字以内を意識しているか
- [ ] 過度な断定表現を避けているか
- [ ] 用語説明→具体例→メリットの流れがあるか
- [ ] セキュリティ・費用リスクに言及しているか
- [ ] CTAが含まれているか
- [ ] 視聴者を尊重した表現になっているか
- [ ] 具体的な数字・例があるか
- [ ] 構成が明確で目次があるか
