# 良い例：新機能紹介

Claude Codeの動的ルール読み込み機能を紹介する台本の例。
（とまださん動画「20251211_Claude_Codeの動的ルール読み込み機能」を参考）

---

## 台本情報

- 想定尺: 10分
- 文字数: 約2,500字
- 対象: Claude Code中級者
- タイプ: 新機能紹介

---

## 評価スコア（参考）

| 軸 | スコア | 評価ポイント |
|----|--------|-------------|
| Structure | 19/20 | 冒頭-本編-締めが明確、段階的説明 |
| Speech Pattern | 18/20 | 語尾多様、親近感表現あり |
| Engagement | 14/15 | 問いかけ・包含表現が豊富 |
| Technical Accuracy | 14/15 | 用語正確、リスク言及あり |
| Readability | 14/15 | 短文中心、リズムよい |
| NG Word | 10/10 | NGワードなし |
| CTA | 5/5 | 登録・高評価・学びの活用 |
| **合計** | **94/100** | **Grade: A** |

---

## 台本

### 冒頭（0:00-1:00）

Claude CodeではCLAUDE.mdというファイルに
開発の共通のルールを設定することができます。

ただこちらのファイル、カスタマイズを続けるうちに
どんどん肥大化していってしまうことはないでしょうか。

Claude Codeでは/contextというコマンドを使うと
コンテキスト、言うなればClaude Codeの記憶の容量を確認することができるんですが、
例えば700行近くのCLAUDE.mdとなると
それだけで6000トークン近くを常に消費することになります。

この中にはフロントエンドのルールやバックエンドのルールなど
いろいろと混在させることもあるかと思うんですけれども、
厄介なことにフロントエンドの実装をしている時にも
バックエンドやAPIの開発ルールまで読み込んでしまうのです。

人間で言えば家でリラックスをしている時にも
ずっと仕事のことが頭にあるような状態です。
これは厄介ですよね。

そこで登場するのが.claude/rules/という機能です。
今回の動画ではサクッとこちらの使い方、
そして効果のほどを見ていきましょう。

---

### 本編セクション1: 機能の概要（1:00-2:30）

これは本当に数日前に追加された機能で、
ルールをファイルごとに分割して書くことができます。

しかもこちらpathsというGlobパターンの機能がありまして、
こちらを設定するとファイルの拡張子とかパスだったりとか、
こういった単位で対象のファイルを操作したときだけ、
もしくはフォルダの中を操作したときだけ
読み込まれることになります。

例えばTypeScriptの拡張子である.tsという
ファイルに対してだけルールを適用することが可能です。

しかもこのように例えばAPIの開発に関わるルールですとか、
他にもフロントエンドやバックエンド、テストに関するルールなど、
自分で好きなようにフォルダ分けをすることも可能です。

---

### 本編セクション2: 実演（2:30-5:30）

今回用意した個別のルールはこちらの4つのルールファイルとなっています。

まず共通的に読み込むルール。
これはClaude Codeからの回答の最後に
星マークを付けてもらうように設定しています。
先ほどとは違って特にpathsは指定していないので、
これは常時適用されるルールということです。

実際Claude Codeで/memoryというコマンドを入力すると
読み込まれているルールが表示されるわけなんですが、
他にもあるにも関わらず、この
general.mdだけが読み込まれていることがわかります。

例えば「こんにちは」という何もファイルには
関係ないプロンプトを投げてみましょう。
すると常時適用ルールの通り、最後に
星マークがついていることがわかります。

つまりCLAUDE.mdとはまた別に
共通のルールを設定できていることがわかります。

---

### 本編セクション3: TypeScriptルールの検証（5:30-7:30）

では次にこちらのTypeScriptに関する
typescript.mdというルールファイルを読み込んでみましょう。

これは.tsのファイルについて読み込むときに使われるものですね。
先ほどと同じように最後にこの青のダイヤマークと「TS」
という文字を一緒につけるようにしてもらっています。

そして読み込んでみるのはこちらのsrcの中にある
index.tsというファイルを読んでみましょう。

ルールが正しく読み込まれれば、
この.tsというファイルを読み込むときのルール通り、
末尾にこちらの文字が付くはずです。

ではこちらのファイルを読んでくださいと実行してみましょう。
すると今ですね、Readツールが読み込まれた後に
特に指定はしていないんですが、
TypeScript用のルールファイルが動的に、
つまり後から読み込まれていることが分かります。

そして出力の末尾には、
TypeScriptに対するルールであるこちらの青ダイヤと「TS」という文字、
さらに共通のルールとして常に読み込まれている
この常時適用ルールの星の絵文字が出力されていることが分かります。

つまりそれぞれのルールが必要に応じて読み込まれたということが分かります。

---

### 本編セクション4: 複数ルールの同時適用（7:30-9:00）

合わせてもう一つ別なルールとしてこちら、
api-rulesというものを用意しました。

こちらはですねsrc/apiのフォルダの中にある
TypeScriptファイルについて読み込むためのルールです。
こちらでは末尾にコンセントマークと「API」という文字を出力するようにしています。

先ほど読み込んだファイルはAPIの中ではなくて
srcの直下にあったため、こちらのルールが適用されていなかったはずです。

では試しにapiフォルダの中のこのファイルを読んでくださいと
このように聞いてみましょう。

今度はですねReadツールが実行されるときに
apiフォルダの中専用のルールと、さらにTypeScript専用のルール、
それぞれが読み込まれて最終的にルール1つ目、そして2つ目、
さらに常時適用のルール、
合計で3つのルールがそれぞれ適用された出力になっていることがわかります。

ちなみにここでまた別なTypeScriptファイルをClaude Codeに読み込んでもらうと、
すでにルールがコンテキスト、つまり頭の中に残っている状態ですので、
もう一度読み込まれるということはありません。その点はご安心ください。

---

### 締め（9:00-10:00）

ということで今日のまとめとしては、
.claude/rules/を使えばCLAUDE.mdが肥大化して
コンテキストを圧迫してしまう問題を解決できること、
さらにpathsを指定することで拡張子やフォルダベースで
読み込むルールを個別に指定しコンテキストを節約できること、
さらに複数のルールを同時に適用できること、
これらのことを学んでいきました。

コンテキストの管理はAI駆動開発で非常に重要な課題の一つです。
ぜひ今回の動画の学びを開発に生かしていただければと思います。

今日の動画が参考になったという方は
ぜひチャンネル登録と高評価で応援をお願いします。
それではまた次の動画でお会いしましょう。
ご視聴ありがとうございました。

---

## この台本の良いポイント

### Structure
- 冒頭で問題提起（CLAUDE.md肥大化）→ 価値提示（解決策）が明確
- 本編が段階的（概要→実演→検証→応用）
- 締めで学びを3点にまとめ

### Speech Pattern
- 語尾が多様（ですね、になります、でしょう、わけなんですが）
- 「皆さんも〜ないでしょうか」で共感
- 「これは厄介ですよね」で距離感を縮める

### Engagement
- 「人間で言えば〜」の例えで理解促進
- 「ご安心ください」で視聴者への配慮

### Technical Accuracy
- 具体的な数字（700行、6000トークン）
- ツール名の正確な表記（Claude Code, Glob）
- 「数日前に追加された」で最新性を示す

### Readability
- 短文の連続でテンポよく
- 操作→結果→解釈の流れが明確
