# 良い例：ツール紹介

Google Antigravityを紹介する台本の例。
（とまださん動画「20251118_【速報】Google_Antigravity」を参考）

---

## 台本情報

- 想定尺: 12分
- 文字数: 約3,000字
- 対象: AI駆動開発に興味がある人
- タイプ: ツール紹介（速報）

---

## 評価スコア（参考）

| 軸 | スコア | 評価ポイント |
|----|--------|-------------|
| Structure | 18/20 | 速報形式で概要重視、実演あり |
| Speech Pattern | 17/20 | カジュアルな強調語、親近感 |
| Engagement | 14/15 | 驚きの共有、価格への言及 |
| Technical Accuracy | 13/15 | 競合比較、注意点言及 |
| Readability | 14/15 | 会話的なテンポ |
| NG Word | 10/10 | NGワードなし |
| CTA | 5/5 | 公式ドキュメント誘導、CTA |
| **合計** | **91/100** | **Grade: A** |

---

## 台本

### 冒頭（0:00-1:30）

この動画を収録している数時間前に、
GoogleからAntigravityという新しいIDE、
つまりエディターが登場しました。

こちらはCursorやWindsurfなどと同じく
AIが組み込まれていて、
登場したばかりのGemini 3 Proなどのモデルを
効率的に使いながら開発を進めることができます。

しかも驚くべきがこのプライシングというところを見ますと、
個人であれば無料で使えて、
さらにGemini 3 ProやClaude Sonnet 4.5やGPT-OSSなど
複数のモデルについて使える上に、
入力の補完機能だったり、
しかもコマンドの実行まで無制限に行えるということです。

現在はパブリックプレビューということですので、
正式にリリースされたらまた違ってくる可能性もありますが、
あまり費用をかけたくないという方は試してみるとよいでしょう。
こちらのダウンロードボタンから
お使いのOSにあったものを用意しましょう。

---

### 本編セクション1: 全体像（1:30-3:30）

ということで今日はざっくりと全体像だけをお見せしようと思うんですが、
エディターの全体像としてはこのようになっています。

左側にソースツリーだったりとか、
真ん中にファイルを表示する場所があるというのは
同じところではあるんですけどもこのような形ですね。
右側にエージェントと会話するためのパネルが用意されています。
これはCursorなどと同じかと思います。

動画の中ではスキップしたんですけれども、
Googleアカウントと連携すれば
それだけで使うことができるというのは非常に簡単でうれしいですね。
しかも無料というのがやはり大きいでしょう。

---

### 本編セクション2: モード説明（3:30-5:30）

ざっくりと全体像を見ていきましょう。
ここでチャットをするとそのまま使えまして、
例えばじゃあそうですね、
Helloというプロンプトを渡すわけなんですが、
ここでまずモードを選べまして、
1つがPlanningモード、
そしてもう1つがFastモードというふうになっています。

このFastモードが通常のコーディングなどで使えるモードだと思うんですが、
もう1つのPlanningモードというのは
これからやることに対して事前に計画を立てるといったモードですね。

CursorやClaude Codeをはじめとした
いろんなAIエージェントでは同じようなモードがありますので、
複雑な作業だったりとか事前のリサーチが必要な時には
こちらのPlanningモードを使うのがよいでしょう。

さらに特筆すべきはモデルの選択でして、
現時点ですとこのように
Gemini 3 Proそして考える量としてのhighとlowを選べつつ、
Claude Sonnet 4.5、さらにthinkingモデルについても選ぶことができます。

Gemini 3 Proが呼び出せるというだけでも
こちら無料という意味ではうれしいんですが、
さらにClaude Sonnet 4.5についても使用できるというのはかなり強みですね。
回数制限を気にすることなく使えるという大きなメリットがあるでしょう。

---

### 本編セクション3: レート制限と回避策（5:30-7:00）

ちょっとまだリリースした直後で使っている方も多いのか、
私の場合だと少しレスポンスが遅かったというところはあるのですが、
Gemini 3 Proだとサクサクと使えました。

ではとりあえずFastというふうにしつつ、
挨拶だけ返してもらいましょう。

レートリミットが一応あったようですね。
先ほどの公式サイトに戻りますと
レートリミットがこのように表示されているリンクがあるので、
こちら見てみますとモデルごとにそしてプランごとに
使える制限が決まってまして、
私の場合だと先ほど少し使ったために
Gemini 3 Proについてはリミットがすぐにいってしまったといったようですね。

では試しに別のモデルということで、
Claude Sonnet 4.5を選んでみましょうか。
こちらだとどうでしょう。
こちらだと問題なく使えたようです。

まだレートリミットがどのような仕組みになっているのか、
どれくらいの時間で制限がリセットされるのかなどは
まだ詳しい情報は見つからなかったんですけれども、
他のモデルに切り替えれば問題なく使えそうですね。

---

### 本編セクション4: 入力補完機能（7:00-8:30）

さてその他なんですけれども、
特筆すべきところとしては先ほどお伝えしたように
入力の補完ができるということです。

例えばちょっと拡大しまして、
今ここにMarkdownのこのような見出しの構造をつけると
このように入力補完がすぐに表示されまして、
Tabキーを押してすぐに補完をすることもできます。

またこの入力補完が登場している最中にですね、
カーソルを合わせますといくつかコマンドが表示されるんですが、
このAccept Wordというところをクリックすると
このように部分的にですね、
クリックするたびに少しずつ補完を受け付けるといった
少し高度な補完も用意されています。

これについても先ほどプライシングページで見たように
特に制限なく利用できるというのはかなりうれしいところではないでしょうか。

---

### 本編セクション5: Agent Manager（8:30-10:30）

ではその他の機能についても見ていきましょう。
このEditorにおいてはSwitch to Agent Managerということで、
Command+Eを押しますとAgent Managerというパネルを開けそうですので見ていきましょう。

どうやらこちらはおそらくなんですけども、
CursorでもあるようなEditorウィンドウと
エージェントだけが動くような、
基本的にエージェントに任せるようなそういったウィンドウのように見えます。

Editorでソースコードを直接見ながら編集するというよりは
基本的にAIに指示を与えて試すといったモードのようですね。

そして気になるのはこちらのWorkspacesというところなのですが、
私は結構AIエージェントが作業中の待ち時間を使って
いろんなプロジェクトを同時並行で動かすことを使い方としてよくやりますので、
このように同じウィンドウの中で複数のWorkspace、
もといプロジェクトを同時に動かして管理できるというのはかなり助かります。

---

### 締め（10:30-12:00）

ということで今回は速報ベースでしたので
あまり深くは入り込めなかったんですけれども、
GoogleのAntigravityについてできることとか
ざっくり概要をお伝えしました。

今回ご紹介しなかった機能として
Antigravityと直接専用のChromeが連携できるような機能とかもあったんですけれども、
私が試した限りですとうまく開けなかったりとか
まだ不安定なところもありました。

ただMCPを使わなくても直接ブラウザと連携できたりとか、
さらにこちらChromeベースですので
Googleアカウントのログイン状態を保ったまま
ブラウザの操作ができるようですので、
もちろん注意は必要ではあるんですけれども、
かなり柔軟な使い方ができそうです。

そして何より最初にお伝えした通り
個人であれば無料で使えるというところが大きなメリットではありますので、
まずは費用を抑えたいという方は
こちらのGoogle Antigravityを使ってみてはいかがでしょうか。

詳しい使い方についてはこちらのExplore Use Casesというところで
使い方の例を見ていただくか、
もしくはResourcesのDocumentationのところを見ていただきますと
基本的なできることとか使い方について確認することができます。
ぜひこちらも読んで使いこなしてみてはいかがでしょうか。

ということで今日は数時間前に登場したばかりの
Google Antigravityについてざっくり特徴をお伝えいたしました。
今日の動画が参考になったという方は
ぜひチャンネル登録と高評価で応援をお願いします。
それではまた次の動画でお会いしましょう。
ご視聴ありがとうございました。

---

## この台本の良いポイント

### Structure
- 速報形式で「数時間前に登場」で鮮度アピール
- 機能を複数セクションで段階的に紹介
- 未紹介機能への言及で誠実さを示す

### Speech Pattern
- 「驚くべきが」「かなり強みですね」でインパクト
- 「私の場合だと」で体験共有
- 「うれしいですね」でポジティブな感情表現

### Engagement
- 競合ツール（Cursor, Windsurf）との比較で文脈を提供
- 「費用を抑えたい方」でターゲット明確化
- レート制限への正直な言及で信頼性

### Technical Accuracy
- モデル名を正確に記載（Gemini 3 Pro, Claude Sonnet 4.5）
- 公式ドキュメントへの誘導
- 「パブリックプレビュー」で状況を正確に伝達

### Readability
- 実演しながらの説明でテンポよく
- 「ということで」で区切りを明確に
