# AI Saborou式パターン辞書

AI Saborouチャンネルの台本分析から抽出した特徴的な表現パターン。
台本作成時にこれらのパターンを参考にする。

---

## 1. 語尾パターン

### 説明・確認系

| パターン | 使用場面 | 例文 |
|---------|---------|------|
| ですね | 説明の締め、確認 | 「こちらが設定画面ですね」「まさに自立性の源泉と言える考え方ですね」 |
| になります | 結果の提示 | 「セルフホスト版となります」「最終的にこうなります」 |
| ということです | まとめ、言い換え | 「つまりは〜ということですね」 |
| でしょう | 推測、問いかけ | 「大変期待ですね」「おそらくですが」 |

### 変化・推移系

| パターン | 使用場面 | 例文 |
|---------|---------|------|
| てくる | 時系列の変化 | 「どんどん時系列が展開されていく」「だんだん見えてくる」 |
| ていく | 継続的な変化 | 「使い続けていく」「進めていきましょう」 |

### 誘導・提案系

| パターン | 使用場面 | 例文 |
|---------|---------|------|
| してみましょう | 実演への誘導 | 「試してみましょう」「見ていきましょう」 |
| してみます | 自分の行動説明 | 「実際にやってみます」「開いてみます」 |
| できます | 可能性の提示 | 「このように設定できます」「選ぶことができます」 |

---

## 2. 親近感表現

### 実体験共有

| 表現 | 使用タイミング | 例文 |
|------|--------------|------|
| 私も〜してます | 信頼性構築 | 「私はもう業務外の普段の会話は基本このGoogle AI Studioで行っています」 |
| 私も最初は〜 | 共感ポイント | 「私も最初は不安でしたが」 |
| 私の場合は | 具体例の提示 | 「私の場合はAIにお願いしてから」 |
| 正直に言うと | 本音の共有 | 「正直に言うと、ここが一番難しいです」 |

### 視聴者包含

| 表現 | 効果 | 例文 |
|------|-----|------|
| 皆さんも | 一体感 | 「皆さんもAIと長々と話していった時に、なんか精度落ちてる気がするとか」 |
| 〜ないでしょうか | 共感誘導 | 「経験あるのではないでしょうか」 |
| あなたも | ターゲティング | 「そんなあなたに向けて」 |

### 感情表現

| 表現 | 使用場面 | 例文 |
|------|---------|------|
| なんか複雑な気持ち | 共感ポイント | 「なんか複雑な気持ちになりました」 |
| 厄介ですよね | 問題共有 | 「これは厄介ですよね」 |
| うれしいですね | ポジティブ共感 | 「無料というのはかなりうれしいですね」 |

---

## 3. カジュアル強調語

### 程度の強調

| 表現 | 強度 | 例文 | 推奨頻度 |
|------|-----|------|---------|
| めちゃくちゃ | 強 | 「めちゃくちゃ下がっています」 | 1動画2-3回 |
| かなり | 中 | 「かなり便利です」「かなり強みですね」 | 制限なし |
| 結構 | 中弱 | 「結構使えます」 | 制限なし |
| 本当に | 中 | 「本当になんで無料なんだこれ」 | 適度に |

### 驚きの導入

| 表現 | 使用場面 | 例文 |
|------|---------|------|
| なんと | 予期しない情報 | 「なんとGoogleログインして」「なんと無料で使えてしまう」 |
| 驚くべきが | 重要な発見 | 「驚くべきがこのプライシング」 |
| 実は | 隠された情報 | 「実はこの機能」 |

### 特徴的スラング

| 表現 | 意味 | 使用例 | 注意 |
|------|-----|-------|------|
| バグってる | 素晴らしい（褒め言葉） | 「この機能バグってます」「本当になんで無料なんだこれ」 | 1動画1回まで |
| 叩く | APIを呼び出す | 「APIを叩く」「エンドポイントを叩く」 | 技術文脈で使用 |
| てきな | 〜的な（カジュアル） | 「設定てきなやつ」「塾講師風味みたいなこと」 | 控えめに |

---

## 4. 構造的フレーズ

### セクション遷移

| フレーズ | 使用目的 | 例文 |
|---------|---------|------|
| それでは〜しましょう | 次のステップへ | 「それでは用語を説明したところで、論文の内容に入っていきます」 |
| 〜について解説します | 新しいトピック導入 | 「n8n内に登場する必須で知っておきたい用語を5つ解説します」 |
| では〜見ていきましょう | 実演開始 | 「では実際に見ていきましょう」 |
| 次に〜 | スムーズな転換 | 「次にリクエストの送り方についてご紹介します」 |

### セクション終了

| フレーズ | 使用目的 | 例文 |
|---------|---------|------|
| 以上が〜でした | セクション終了 | 「以上がn8nを使う時に知っておきたい概念でした」 |
| ということで | まとめへの遷移 | 「ということで今日のまとめとしては」 |

### 補足・脱線

| フレーズ | 使用目的 | 例文 |
|---------|---------|------|
| ちなみに | 補足情報 | 「ちなみに使い方のコツなのですが」 |
| 余談ですが | 小ネタ挿入 | 「余談ですが、開発者の方が」 |
| 一応 | 念のための説明 | 「一応補足しておくと」 |

---

## 5. 問題解決パターン

### 論文・技術解説の型

```
問題提示 → 「〜という問題が起きていると説明しています」
   ↓
理由説明 → 「なぜなら〜」「〜の傾向があります」
   ↓
実験説明 → 「実際のところ〜で検証したところ」
   ↓
結論化 → 「つまり〜という結論付けて良さそうです」
   ↓
実践応用 → 「では我々はどうAIと付き合えばいいのでしょうか」
```

### ツール紹介の型

```
ツール概要 → 「〜というツールが登場しました」
   ↓
特徴説明 → 「こちらは〜という特徴があります」
   ↓
比較 → 「〜と比べると」
   ↓
メリット → 「〜という点がうれしいですね」
   ↓
注意点 → 「一方で注意点として」
   ↓
実演 → 「では実際に使ってみましょう」
```

---

## 6. 段階的説明パターン

### 難易度レベル

| レベル | 説明方法 | 例 |
|--------|---------|---|
| 初級 | 用語の定義から | 「〜とは〜のことです」「まず基本として」 |
| 中級 | 実践例を交えて | 「実際にやってみると」「例えば」 |
| 上級 | 応用パターン・Tips | 「さらに深掘りするなら」「応用として」 |

### 3段階説明テンプレート

```
1. 用語説明（What）:
   「〜とは〜のことです」
   「シンプルに言えば〜」

2. 具体例（How）:
   「例えば〜の場合」
   「実際に〜してみると」

3. メリット/注意点（Why）:
   「これにより〜できます」
   「一方で〜に注意してください」
```

---

## 7. セキュリティ・リスク言及パターン

### 必須言及ポイント

| 対象 | 言及パターン | 例文 |
|------|------------|------|
| APIキー | 公開禁止の警告 | 「絶対に公開しないよう厳重に管理してください」 |
| 費用 | 発生可能性の説明 | 「〜円かかる可能性があります」「使いすぎると費用が発生します」 |
| 権限 | 最小権限の推奨 | 「必要最小限の権限で設定することをお勧めします」 |

### 注意喚起フォーマット

```
一方で注意点として、[リスク内容]があります。
具体的には[具体例]なので、[対策]するようにしてください。
```

---

## 8. CTA（行動喚起）パターン

### ソフトCTA

```
「ぜひ試してみてください」
「きっかけにしてください」
「参考にしていただければと思います」
```

### ダイレクトCTA

```
「今日の動画が参考になったという方はぜひチャンネル登録と高評価で応援をお願いします」
「ためになったとか難しすぎたなどあればコメントで教えてください」
```

### クロージング

```
「それでは次回の動画で」
「それではまた次の動画でお会いしましょう」
「ご視聴ありがとうございました」
```
