# 台本評価基準（100点満点・7軸）

YouTube台本の品質を定量的に評価するための基準。
**合格基準**: 総合90点以上 + 全軸が閾値以上

---

## 評価軸サマリー

| 軸 | 配点 | 閾値 | 内容 |
|----|------|------|------|
| Structure | 20pt | 16pt (80%) | 冒頭-本編-締めの3部構成、段階的説明 |
| Speech Pattern | 20pt | 16pt (80%) | 語尾パターン、親近感表現、強調語 |
| Engagement | 15pt | 12pt (80%) | 視聴者への呼びかけ、包含表現 |
| Technical Accuracy | 15pt | 12pt (80%) | 専門用語の正確性、リスク言及 |
| Readability | 15pt | 12pt (80%) | 文の長さ、段落構成、音読リズム |
| NG Word | 10pt | 10pt (100%) | 禁止表現の不使用（0件必須） |
| CTA | 5pt | 4pt (80%) | 行動喚起（登録・高評価・コメント） |

---

## 1. Structure Score（20点）

台本の構造が適切に設計されているか。

### チェック項目

| 項目 | 配点 | チェック内容 |
|------|------|-------------|
| 3部構成の完備 | 8pt | 冒頭・本編・締めが明確に分かれている |
| 段階的説明 | 8pt | 用語→例→メリットの3段階で説明している |
| 接続詞による流れ | 4pt | セクション間が接続詞でスムーズに繋がっている |

### 採点基準

**8点（3部構成）:**
- 冒頭に問題提起または疑問提起がある
- 本編が複数セクションに分かれている
- 締めに要約とCTAがある

**8点（段階的説明）:**
- 各トピックで「〜とは」という用語定義がある
- 具体例やデモンストレーションがある
- メリットまたは注意点の言及がある

**4点（接続詞）:**
- 「ではまず〜」「次に〜」「さらに〜」「最後に〜」などの使用

---

## 2. Speech Pattern Score（20点）

話し方のパターンがターゲットスタイルに合っているか。

### チェック項目

| 項目 | 配点 | チェック内容 |
|------|------|-------------|
| 語尾の多様性 | 6pt | 3種類以上の語尾パターン使用 |
| 親近感表現 | 6pt | 2個以上の親近感表現使用 |
| 強調語の適切な使用 | 4pt | カジュアル強調語の自然な使用 |
| 段階的説明 | 4pt | 初級→中級→上級の流れ |

### 採点基準

**6点（語尾）:**
- 「ですね」（確認）、「てくる」（変化）、「になります」（結果）など3種類以上

**6点（親近感）:**
- 「私も〜してます」「皆さんも〜ないでしょうか」など2個以上

**4点（強調語）:**
- 「めちゃくちゃ」「かなり」「本当に」「なんと」の自然な使用

**4点（段階性）:**
- 基本→応用の流れ、または簡単→難しいの流れがある

---

## 3. Engagement Score（15点）

視聴者を巻き込む表現があるか。

### チェック項目

| 項目 | 配点 | チェック内容 |
|------|------|-------------|
| 問いかけ | 5pt | 視聴者への問いかけが2回以上 |
| 包含表現 | 5pt | 「皆さん」などの包含表現が3回以上 |
| 実体験共有 | 5pt | 「私も〜」という実体験が1回以上 |

### 採点基準

**5点（問いかけ）:**
- 「〜ないでしょうか」「〜と思いませんか」「〜ではありませんか」

**5点（包含表現）:**
- 「皆さんも」「あなたも」「一緒に」

**5点（実体験）:**
- 「私も使ってます」「私の場合は」「実際に試したところ」

---

## 4. Technical Accuracy Score（15点）

技術的な正確性とリスク意識があるか。

### チェック項目

| 項目 | 配点 | チェック内容 |
|------|------|-------------|
| 用語の正確性 | 6pt | 専門用語が正しく使われている |
| リスク言及 | 5pt | セキュリティ/費用リスクへの言及が1回以上 |
| 情報の信頼性 | 4pt | 公式ドキュメントや実測値への参照 |

### 採点基準

**6点（用語）:**
- ツール名の正確な表記（Claude Code, Codex CLI, MCP等）
- 技術用語の適切な説明

**5点（リスク）:**
- APIキーの管理、費用発生、権限設定などへの注意喚起

**4点（信頼性）:**
- 「公式ドキュメントによると」「実際に試したところ」

---

## 5. Readability Score（15点）

音読しやすく、理解しやすい文章か。

### チェック項目

| 項目 | 配点 | チェック内容 |
|------|------|-------------|
| 文の長さ | 6pt | 1文40字以内が80%以上 |
| 段落構成 | 5pt | 適切な改行と段落分け |
| 音読リズム | 4pt | 息継ぎしやすい構成 |

### 採点基準

**6点（文の長さ）:**
- 長文を避け、短い文を連続させる
- 接続詞で繋ぐより、文を分ける

**5点（段落構成）:**
- 1つの話題ごとに段落を分ける
- 視覚的に読みやすい

**4点（リズム）:**
- 「〜です。〜ですね。」のようなリズム
- 息継ぎポイントが適切

---

## 6. NG Word Score（10点）

禁止表現を使用していないか。

### 採点基準

| NGワード数 | 得点 |
|-----------|------|
| 0件 | 10pt（満点） |
| 1件以上 | 0pt（即失格） |

**詳細は [ng-expressions.md](ng-expressions.md) を参照**

---

## 7. CTA Score（5点）

適切な行動喚起があるか。

### チェック項目

| 項目 | 配点 | チェック内容 |
|------|------|-------------|
| チャンネル登録促進 | 2pt | 登録を促す文言がある |
| 高評価依頼 | 2pt | 高評価を依頼する文言がある |
| コメント促進 | 1pt | コメントを促す文言がある |

### 採点基準

- 押し付けがましくない自然なCTA
- 締めのセクションに配置

---

## 総合評価グレード

| グレード | スコア | 判定 |
|---------|-------|-----|
| A+ | 95+ | 即公開可能・お手本レベル |
| A | 90-94 | 公開可能・軽微な修正のみ |
| B+ | 80-89 | 改善推奨・一部修正必要 |
| B | 70-79 | 要改善・複数箇所の修正必要 |
| C | <70 | 大幅な修正必要・構成見直し |

---

## 評価レポート形式

```json
{
  "total_score": 85.5,
  "grade": "B+",
  "passed": false,
  "failed_axes": [
    {"axis": "speech_pattern", "score": 14, "threshold": 16, "deficit": 2}
  ],
  "breakdown": {
    "structure": {"score": 18, "max": 20, "threshold": 16, "passed": true},
    "speech_pattern": {"score": 14, "max": 20, "threshold": 16, "passed": false},
    "engagement": {"score": 13, "max": 15, "threshold": 12, "passed": true},
    "technical_accuracy": {"score": 13, "max": 15, "threshold": 12, "passed": true},
    "readability": {"score": 13, "max": 15, "threshold": 12, "passed": true},
    "ng_word": {"score": 10, "max": 10, "threshold": 10, "passed": true},
    "cta": {"score": 4.5, "max": 5, "threshold": 4, "passed": true}
  },
  "improvement_suggestions": [
    "Speech Pattern: 語尾パターンのバリエーションを増やす（現在2種類→3種類以上）",
    "Speech Pattern: 親近感表現「私も〜」を追加する"
  ]
}
```
