# 禁止表現リスト（NG Expressions）

YouTube台本で使用してはいけない表現のリスト。
**1件でも使用すると NG Word Score が0点になる。**

---

## 自動チェック vs 手動チェック

| チェック種別 | 対象 | 検出方法 |
|-------------|------|---------|
| **自動チェック** | カテゴリ1〜5のNGワード | `validate_script.py` で正規表現検出 |
| **手動チェック** | カテゴリ6、グレーゾーン | 文脈判断が必要 |

**自動チェックで1件でも検出されると NG Word Score = 0点（即失格）**

---

## カテゴリ別NGワード

### 1. 誇大表現 🤖 自動チェック対象

視聴者の信頼を損なう過度な表現。

| NG | 理由 | 代替案 |
|----|------|-------|
| ヤバい | 品がない、具体性がない | すごい、素晴らしい、驚きました |
| 神 | 安っぽい、信頼性が低い | 優れた、便利な、高品質な |
| 最強 | 根拠がない、主観的すぎる | 非常に強力な、おすすめの、効果的な |
| 爆速 | 誇張表現 | 高速な、効率的な、〜秒で完了 |
| 革命的 | 大げさ | 画期的な、新しい、これまでにない |
| 神アプデ | 誇張 | 大型アップデート、注目の更新 |
| チート級 | 不適切 | 非常に便利な、強力な |

---

### 2. 過度な断定 🤖 自動チェック対象

不確実なことを断定する表現。

| NG | 理由 | 代替案 |
|----|------|-------|
| 絶対 | 例外がある可能性 | おそらく、基本的に、多くの場合 |
| 必ず | 保証できない | 高い確率で、ほとんどの場合 |
| 間違いなく | 断定しすぎ | 高い可能性で、かなりの確率で |
| 100% | 数値的に不正確 | ほぼ確実に、非常に高い確率で |
| 確実に | 保証できない | おそらく、期待できる |

---

### 3. 安易な約束 🤖 自動チェック対象

視聴者に誤った期待を抱かせる表現。

| NG | 理由 | 代替案 |
|----|------|-------|
| 簡単です | 人によって異なる | 手順に従えば、コツを掴めば |
| すぐできます | 時間感覚は個人差 | 〜分程度で、比較的短時間で |
| 誰でもできます | スキル差がある | 基礎があれば、慣れれば |
| 失敗しません | 失敗の可能性はある | リスクを抑えられます、安全に |
| 一瞬で | 誇張 | 素早く、スムーズに |
| 楽々 | 人による | 効率的に、手間を省いて |

---

### 4. 視聴者を下に見る表現 🤖 自動チェック対象

上から目線や煽りになる表現。

| NG | 理由 | 代替案 |
|----|------|-------|
| 知らないと損 | 煽り、脅迫的 | 知っておくと便利、役立つ |
| まだやってないの？ | 上から目線 | これから始める方へ、今からでも |
| 常識ですが | 見下し | 基本として、ポイントとして |
| 当たり前ですが | 見下し | 基本的なことですが |
| 情弱 | 侮辱的 | （使用しない） |
| 〜も知らないの？ | 攻撃的 | （使用しない） |

---

### 5. 品のない表現 🤖 自動チェック対象

プロフェッショナルさを損なう表現。

| NG | 理由 | 代替案 |
|----|------|-------|
| ぶっちゃけ | カジュアルすぎる | 正直に言うと、率直に言えば |
| マジで | 品がない | 本当に、実際に |
| クソ〜 | 下品 | 非常に〜、とても〜 |
| ヤバい | 曖昧、品がない | すごい、驚きの |
| ガチで | カジュアルすぎる | 本当に、実際に |
| 超〜 | 子供っぽい | 非常に、とても |

---

### 6. 不正確・誤解を招く表現 👁️ 手動チェック対象

技術的に不正確または誤解を招く表現。文脈によって判断が必要。

| NG | 理由 | 代替案 |
|----|------|-------|
| 完全無料 | 条件がある場合が多い | 基本無料、無料プランあり |
| 永久に無料 | 変更の可能性 | 現時点では無料、今のところ無料 |
| 全自動 | 完全自動は稀 | 自動化できる、手間が減る |
| 万能 | 限界がある | 汎用的な、多目的な |
| 完璧 | 完璧はない | 非常に優れた、高品質な |

---

## グレーゾーン表現 👁️ 手動チェック対象

使用可能だが、多用は避けるべき表現。自動チェックでは検出されない。

| 表現 | 注意点 | 推奨頻度 |
|------|--------|---------|
| めちゃくちゃ | 1動画2-3回まで | 控えめに |
| かなり | 適度に使用 | 問題なし |
| 結構 | 適度に使用 | 問題なし |
| なんと | インパクト用に | 1-2回 |
| バグってる（褒め言葉として） | 文脈次第 | 1回まで |

---

## チェック方法

### 自動チェック対象（validate_script.py）

`validate_script.py` が正規表現で自動検出するパターン:

**実装場所**: `.claude/skills/youtube-script-writer/scripts/validate_script.py` の `NG_PATTERNS`

以下のパターンを正規表現でチェック:

```python
NG_PATTERNS = [
    # 誇大表現
    r'ヤバい|やばい|ヤバ',
    r'神(?!経|社|様)',  # 神経、神社、神様は除外
    r'最強',
    r'爆速',
    r'革命的',
    r'チート級',

    # 過度な断定
    r'絶対(?!に.{0,5}ない)',  # 「絶対にしないで」は除外
    r'必ず(?!しも)',  # 「必ずしも」は除外
    r'間違いなく',
    r'100%',
    r'確実に',

    # 安易な約束
    r'簡単です',
    r'すぐできます',
    r'誰でもできます',
    r'失敗しません',
    r'一瞬で',
    r'楽々',

    # 視聴者を下に見る
    r'知らないと損',
    r'まだやってないの',
    r'常識ですが',
    r'情弱',

    # 品のない表現
    r'ぶっちゃけ',
    r'クソ',
    r'ガチで',
]
```

### 手動チェック対象

文脈によって判断が必要な表現:
- 「マジで」→ 技術的な文脈ならNG
- 「超」→ 連発はNG
- 「完全無料」→ 条件を説明していればOK

---

## 言い換えのコツ

### 原則

1. **具体的な数字を使う**
   - NG: 「めちゃくちゃ速い」
   - OK: 「処理時間が3分の1になりました」

2. **根拠を添える**
   - NG: 「最強のツールです」
   - OK: 「私が試した中では最も効率的でした」

3. **個人の体験として語る**
   - NG: 「誰でもできます」
   - OK: 「私も最初は不安でしたが、30分で使えるようになりました」

4. **条件を明示する**
   - NG: 「完全無料」
   - OK: 「個人利用なら無料で使えます」
