# 動画尺別ガイド

動画の長さに応じた文字数・時間配分の目安。

---

## 基本換算

| 項目 | 目安 |
|------|-----|
| 話す速度 | 約250-300字/分 |
| 1分あたり | 約250字 |
| 5分動画 | 約1,250字 |
| 10分動画 | 約2,500字 |
| 15分動画 | 約3,750字 |
| 20分動画 | 約5,000字 |

---

## 5分動画（ショート）

### 用途
- ポイントを絞った解説
- 1つの機能紹介
- 速報・ニュース

### 時間配分

| パート | 時間 | 文字数 | 内容 |
|--------|------|--------|------|
| 冒頭 | 30秒 | ~150字 | 問題提起＋価値提示 |
| 本編 | 3分30秒 | ~900字 | 1-2セクション |
| 締め | 1分 | ~200字 | 要約＋CTA |

### 構成例

```
## 冒頭（0:00-0:30）
[問題提起] ~100字
[価値提示] ~50字

## 本編（0:30-4:00）
### セクション1（0:30-2:30）~500字
- 用語説明
- 具体例
- ポイント

### セクション2（2:30-4:00）~400字（オプション）
- 補足情報
- 注意点

## 締め（4:00-5:00）
[要約] ~100字
[CTA] ~100字
```

---

## 10分動画（スタンダード）

### 用途
- 標準的な解説動画
- ツール紹介
- 基本的なチュートリアル

### 時間配分

| パート | 時間 | 文字数 | 内容 |
|--------|------|--------|------|
| 冒頭 | 1分 | ~250字 | 問題提起＋価値提示＋目次 |
| 本編 | 7分 | ~1,800字 | 3-4セクション |
| 締め | 2分 | ~450字 | 要約＋実践誘導＋CTA |

### 構成例

```
## 冒頭（0:00-1:00）
[問題提起] ~100字
[価値提示] ~100字
[目次予告] ~50字

## 本編（1:00-8:00）
### セクション1（1:00-3:00）~500字
- 用語説明
- 具体例
- ポイント

### セクション2（3:00-5:00）~500字
- 詳細説明
- 実演

### セクション3（5:00-7:00）~500字
- 応用・Tips
- 注意点

### セクション4（7:00-8:00）~300字（オプション）
- 補足情報

## 締め（8:00-10:00）
[要約] ~200字
[実践誘導] ~100字
[CTA] ~150字
```

---

## 15分動画（ミドル）

### 用途
- 詳細な解説
- 複数機能の紹介
- 比較動画

### 時間配分

| パート | 時間 | 文字数 | 内容 |
|--------|------|--------|------|
| 冒頭 | 1分30秒 | ~400字 | 問題提起＋価値提示＋目次 |
| 本編 | 11分 | ~2,800字 | 4-5セクション |
| 締め | 2分30秒 | ~550字 | 要約＋実践誘導＋CTA |

### 構成例

```
## 冒頭（0:00-1:30）
[問題提起] ~150字
[価値提示] ~150字
[目次予告] ~100字

## 本編（1:30-12:30）
### セクション1: 基礎（1:30-4:00）~600字
### セクション2: 実践（4:00-7:00）~700字
### セクション3: 応用（7:00-9:30）~600字
### セクション4: Tips（9:30-11:30）~500字
### セクション5: 注意点（11:30-12:30）~400字

## 締め（12:30-15:00）
[要約] ~250字
[実践誘導] ~150字
[CTA] ~150字
```

---

## 20分動画（ロング）

### 用途
- 完全ガイド
- 深掘り解説
- 複合チュートリアル

### 時間配分

| パート | 時間 | 文字数 | 内容 |
|--------|------|--------|------|
| 冒頭 | 2分 | ~500字 | 問題提起＋価値提示＋詳細目次 |
| 本編 | 15分 | ~3,800字 | 5-6セクション |
| 締め | 3分 | ~700字 | 詳細要約＋実践誘導＋CTA |

### 構成例

```
## 冒頭（0:00-2:00）
[問題提起] ~200字
[価値提示] ~200字
[目次予告] ~100字

## 本編（2:00-17:00）
### Part 1: 概要（2:00-5:00）~750字
### Part 2: 基本操作（5:00-8:00）~750字
### Part 3: 実践（8:00-11:00）~750字
### Part 4: 応用（11:00-14:00）~750字
### Part 5: Tips & 注意点（14:00-17:00）~800字

## 締め（17:00-20:00）
[詳細要約] ~350字
[実践誘導] ~200字
[CTA] ~150字
```

---

## セクション数の目安

| 動画尺 | 推奨セクション数 | 1セクションあたり |
|--------|----------------|------------------|
| 5分 | 1-2 | 2-3分 |
| 10分 | 3-4 | 2-3分 |
| 15分 | 4-5 | 2-3分 |
| 20分 | 5-6 | 2.5-3分 |

**ポイント**: 1セクション2-3分が視聴者の集中力を維持しやすい。

---

## 文字数調整のコツ

### 長すぎる場合
- 冗長な説明をカット
- 具体例を1つに絞る
- 「ちなみに」の補足を削除
- 重複する表現を統合

### 短すぎる場合
- 具体例を追加
- 「私の場合は〜」の体験談を追加
- よくある質問への回答を追加
- 注意点・Tipsを追加

---

## テンポの調整

### 密度の高いセクション（ゆっくり）
- 用語定義
- 重要な概念説明
- 注意点・警告

### 密度の低いセクション（テンポよく）
- 具体例の羅列
- 画面操作のナレーション
- 箇条書きの読み上げ
