# 台本構造テンプレート

YouTube台本の3部構成（冒頭-本編-締め）のテンプレート。

---

## 全体構成

```
┌─────────────────────────────────────┐
│ 冒頭（10-15%）                       │
│ - 問題提起/疑問提起                  │
│ - 価値提示                          │
│ - 目次予告                          │
├─────────────────────────────────────┤
│ 本編（70-80%）                       │
│ - セクション1: 用語→例→メリット      │
│ - セクション2: 用語→例→メリット      │
│ - セクション3: 用語→例→メリット      │
│ - ...                               │
├─────────────────────────────────────┤
│ 締め（10-15%）                       │
│ - 要約（今日のポイント）             │
│ - CTA（チャンネル登録・高評価）      │
└─────────────────────────────────────┘
```

**重要**: 挨拶は入れない。いきなり本題に入るスタイル。

---

## Part 1: 冒頭（10-15%）

### 目的
- 視聴者の関心を引く
- この動画で得られる価値を明示
- 最後まで見たくなる構成を予告

### 構成要素

#### 1. 問題提起/疑問提起（必須）

視聴者が抱える課題を言語化して共感を得る。

**パターンA: 問題提起型**
```
[ツール名]では[設定/機能]を[使う/設定する]ことができます。
ただ、[問題点]ということはないでしょうか。
[具体的な困りごと]という経験、あるのではないでしょうか。
```

**パターンB: 疑問提起型**
```
[キーワード]、よく耳にする言葉ではありますが、
実際のところ何を意味しているのか、
よくわかっていないという方も多いのではないでしょうか。
```

**パターンC: 速報型（新機能・新ツール）**
```
[時間/日付]に[会社名]から[ツール名]という新しい[カテゴリ]が登場しました。
こちらは[特徴1]や[特徴2]など、[メリット]を備えています。
```

#### 2. 価値提示（必須）

この動画を見ると何が得られるかを明示。

```
そこで今回の動画では、[トピック]について
[得られる価値1]、[得られる価値2]をお伝えしていきます。
```

または

```
今回は[トピック]とは何なのか、
どうやって使うのか、使う時の注意点をまるっとお伝えしていきます。
```

#### 3. 目次予告（推奨）

今日話す内容を3-5項目で予告。

```
今日は以下の内容でお話しします。
まず[トピック1]について。
次に[トピック2]。
そして最後に[トピック3]という流れで進めていきます。
```

---

## Part 2: 本編（70-80%）

### 目的
- メイントピックを段階的に説明
- 具体例とデモで理解を深める
- 注意点やリスクも言及

### 構成要素

#### セクション構成（3段階説明）

各セクションは以下の3段階で構成:

```
┌─────────────────────────────────────┐
│ 1. 用語説明（What）                  │
│    「〜とは〜のことです」            │
├─────────────────────────────────────┤
│ 2. 具体例/実演（How）                │
│    「例えば〜の場合」「実際に〜」    │
├─────────────────────────────────────┤
│ 3. メリット/注意点（Why）            │
│    「これにより〜」「一方で〜」      │
└─────────────────────────────────────┘
```

#### セクション間の接続

| 順番 | 接続フレーズ |
|------|------------|
| 最初 | 「ではまず〜」「それでは〜から見ていきましょう」 |
| 2番目 | 「次に〜」「続いて〜」 |
| 3番目以降 | 「さらに〜」「加えて〜」 |
| 最後 | 「最後に〜」「そして〜」 |

#### セクション終了

```
以上が[トピック]についてでした。
```

または

```
ということで[トピック]については以上になります。
```

#### 注意点・リスクの言及（必須）

本編のどこかで必ずリスクに言及:

```
一方で注意点として、[リスク内容]があります。
具体的には[具体例]なので、[対策]するようにしてください。
```

---

## Part 3: 締め（10-15%）

### 目的
- 今日の内容を振り返る
- 行動を促す（CTA）
- 次回への期待を作る

### 構成要素

#### 1. 要約（必須）

今日のポイントを簡潔にまとめる。

```
ということで今日のまとめとしては、
[ポイント1]ができること、
[ポイント2]によって[効果]が得られること、
[ポイント3]に注意すること、
これらのことをお伝えしました。
```

または

```
今回は[トピック]について、ざっくり[内容]をお伝えしました。
```

#### 2. 実践への誘導（推奨）

```
ぜひ今回の動画をきっかけに[アクション]してみてください。
```

または

```
[トピック]は[領域]で非常に重要な[概念/ツール]です。
ぜひ今回の学びを[活用場面]に生かしていただければと思います。
```

#### 3. CTA（必須）

```
今日の動画が参考になったという方は
ぜひチャンネル登録と高評価で応援をお願いします。
```

追加オプション:
```
ためになったとか難しすぎたなどあれば
コメントで教えてください。
```

#### 4. クロージング（必須）

```
それではまた次の動画でお会いしましょう。
ご視聴ありがとうございました。
```

---

## 構成チェックリスト

### 冒頭
- [ ] 問題提起または疑問提起がある
- [ ] 価値提示（この動画で得られること）がある
- [ ] 目次予告がある（推奨）
- [ ] 挨拶を入れていない（いきなり本題）

### 本編
- [ ] 各セクションが3段階（用語→例→メリット）で構成されている
- [ ] セクション間が接続詞でスムーズに繋がっている
- [ ] 注意点・リスクへの言及がある
- [ ] 具体例やデモが含まれている

### 締め
- [ ] 今日のポイントの要約がある
- [ ] チャンネル登録・高評価のCTAがある
- [ ] クロージングの挨拶がある
