# Cardiology Keywords for SEO Optimization

## Primary Keywords (High Volume, High Intent)

### Conditions & Symptoms
- heart attack symptoms
- chest pain causes
- heart palpitations
- high blood pressure
- atrial fibrillation (afib)
- heart failure symptoms
- coronary artery disease
- heart murmur
- irregular heartbeat
- angina symptoms

### Procedures & Treatments
- cardiac stent
- bypass surgery (CABG)
- angioplasty
- heart catheterization
- pacemaker
- defibrillator (ICD)
- ablation procedure
- stress test
- echocardiogram (echo)
- cardiac CT scan

### Tests & Diagnostics
- ECG/EKG
- troponin test
- cholesterol levels
- lipid panel
- cardiac calcium score
- holter monitor
- event recorder
- treadmill test
- nuclear stress test

### Medications
- beta blockers
- statins
- blood thinners
- ACE inhibitors
- aspirin for heart
- warfarin vs eliquis
- metoprolol
- atorvastatin

## Long-Tail Keywords (Lower Volume, Higher Conversion)

### Patient Questions
- "what does a heart attack feel like"
- "can you have a heart attack without chest pain"
- "how long does angioplasty take"
- "heart stent recovery time"
- "afib stroke risk"
- "when to go to er for chest pain"
- "heart attack vs anxiety attack"
- "can stress cause heart attack"
- "what is a good cholesterol level"
- "side effects of blood thinners"

### Comparison Searches
- "stent vs bypass surgery"
- "eliquis vs xarelto"
- "stress test vs calcium score"
- "heart attack vs cardiac arrest"
- "angina vs heart attack"
- "systolic vs diastolic blood pressure"

### How-To Queries
- "how to lower cholesterol"
- "how to prevent heart disease"
- "how to read an ecg"
- "how to take blood pressure"
- "how to recover from heart attack"

## Keyword Clusters for Topic Authority

### Cluster 1: Heart Attack
- Core: heart attack
- Supporting: myocardial infarction, heart attack symptoms, silent heart attack, heart attack in women, heart attack vs cardiac arrest, mini heart attack, heart attack recovery, heart attack prevention

### Cluster 2: Cholesterol
- Core: cholesterol
- Supporting: LDL cholesterol, HDL cholesterol, triglycerides, cholesterol levels, lower cholesterol, statins, cholesterol diet, cholesterol medication, cholesterol ratio

### Cluster 3: AFib
- Core: atrial fibrillation
- Supporting: afib symptoms, afib treatment, afib ablation, afib stroke risk, afib medication, paroxysmal afib, persistent afib, rate control vs rhythm control

### Cluster 4: Interventional Procedures
- Core: cardiac catheterization
- Supporting: angioplasty, stent, coronary angiogram, PCI, radial access, femoral access, drug eluting stent, restenosis

## Local SEO Keywords (If Applicable)
- "interventional cardiologist [city]"
- "heart doctor near me"
- "cardiac catheterization [city]"
- "best cardiologist [city]"

## Trending Keywords (Check Regularly)

### Current Trends (2024-2025)
- "ozempic heart benefits"
- "covid and heart damage"
- "heart disease in young people"
- "SGLT2 inhibitors"
- "coronary calcium score"
- "heart rate variability"
- "watchman device"
- "tavr procedure"

## Keyword Integration Best Practices

**Title Optimization**:
- Primary keyword in first 5 words
- Keep under 60 characters
- Natural language (don't keyword stuff)
- Include numbers when possible

**Description Optimization**:
- Primary keyword in first sentence
- Include 2-3 related keywords naturally
- Use keyword variants
- Include timestamps with keyword-rich chapter titles

**Tags**:
- Use 8-12 tags
- Mix primary and long-tail keywords
- Include misspellings/variants (afib, a-fib, a fib)
- Add broader category tags (cardiology, heart health)

**Closed Captions**:
- Speak keywords naturally in video
- Correct auto-generated captions for keyword accuracy
- Repeat key terms 3-5 times throughout video

## Keyword Difficulty Assessment

**Low Competition** (easier to rank):
- Specific procedure recovery times
- Medication-specific questions
- Symptom combinations
- Local searches

**Medium Competition**:
- Common condition overviews
- General treatment information
- Comparison topics
- "How to" queries

**High Competition** (harder to rank, but high reward):
- Single-word conditions (e.g., "diabetes")
- Broad symptoms (e.g., "chest pain")
- Generic prevention (e.g., "heart health")
- Mainstream wellness topics

## Voice Search Optimization

People ask voice assistants full questions. Target these patterns:

- "What is [condition]?"
- "How do I know if [symptom]?"
- "What causes [condition]?"
- "When should I see a doctor for [symptom]?"
- "Is [symptom] serious?"
- "What's the difference between [A] and [B]?"

## Seasonal Keyword Opportunities

**January**: new year health goals, heart healthy resolutions
**February**: American Heart Month, heart disease awareness
**March**: women's history (women and heart disease)
**September**: AFib awareness month
**November-December**: holiday heart health, stress and heart
**Year-round**: condition-specific awareness months

## Negative Keywords (Avoid or Use Carefully)

These may trigger incorrect assumptions or violate medical advertising guidelines:
- "cure" (unless referencing specific curable conditions)
- "guaranteed results"
- "miracle treatment"
- "secret" (can sound clickbaity)
- Competitor medication names (unless doing fair comparison)

## Keyword Research Tools to Use

- Google Trends (trending topics)
- YouTube Search Suggest (type partial query, see completions)
- Google Search Console (what you already rank for)
- Answer the Public (question-based keywords)
- Reddit search (real patient language)

## Keyword Performance Metrics to Track

- Impressions (how often you appear in search)
- Click-through rate (CTR) - aim for >10%
- Average view duration from search traffic
- Conversion to subscribers from keyword traffic
- Top performing keywords monthly
