# Visual Snapshot Skill - Setup Guide

This skill integrates **Playwright** via MCP to give your Agent visual capabilities.

## Prerequisites

1.  **Node.js** installed.
2.  **Claude Desktop** or compatible MCP Client.

## Installation

To use this skill, you must add the Playwright MCP server to your Claude Desktop config.

### 1. Install the MCP Server

```bash
npm install -g @modelcontextprotocol/server-playwright
# Or run directly via npx
```

### 2. Configure Claude Desktop

Add this to your `~/Library/Application Support/Claude/claude_desktop_config.json`:

```json
{
  "mcpServers": {
    "playwright": {
      "command": "npx",
      "args": ["-y", "@modelcontextprotocol/server-playwright"]
    }
  }
}
```

### 3. Restart Claude Desktop

Restart the application to load the new tools context.

## Verifying Installation

Ask Claude: _"Can you list the tools available in the playwright server?"_
You should see tools like `playwright_navigate`, `playwright_screenshot`, `playwright_evaluate`.

## Usage with theme-kit

1.  Run `shopify theme dev` to start your local server.
2.  In your chat with Claude, ask it to "Visually verify the home page on mobile".
3.  The Agent will use the Playwright tools to browse `localhost:9292`.
4.  **Pro Tip**: The Agent can use `playwright_evaluate` to execute complex JavaScript directly on the page, enabling high-speed automation without multiple network round-trips.
