---
name: voice-learning
description: Knowledge base for analyzing and replicating writing voice. Use when learning voice patterns or generating voice-matched content.
---

# Voice Learning Skill

This skill provides frameworks and techniques for analyzing writing voice and ensuring content generation matches a learned voice profile.

## Voice Analysis Framework

### The 5 Dimensions of Voice

1. **Lexical Voice** - Word choice
   - Vocabulary complexity (grade level)
   - Industry jargon usage
   - Power words and phrases
   - Words consciously avoided

2. **Syntactic Voice** - Sentence structure
   - Average sentence length
   - Sentence variety (simple, compound, complex)
   - Use of fragments for effect
   - Paragraph length preferences

3. **Rhetorical Voice** - Persuasion patterns
   - Primary appeal (ethos, pathos, logos)
   - Use of questions
   - Analogy and metaphor frequency
   - Storytelling vs. data-driven

4. **Tonal Voice** - Emotional coloring
   - Formality spectrum (1-10)
   - Warmth/distance
   - Confidence level
   - Humor integration

5. **Structural Voice** - Organization
   - Opening patterns (hook types)
   - Transition preferences
   - Closing/CTA style
   - Use of formatting elements

## Voice Extraction Techniques

### From Transcripts

Transcripts reveal natural, unfiltered voice:

- **Listen for filler phrases** - These often carry personality
- **Note explanation patterns** - How do they break down complex ideas?
- **Capture spontaneous analogies** - Unplanned comparisons reveal thinking
- **Track energy shifts** - What topics generate enthusiasm?

### From Written Content

Published writing shows intentional voice:

- **Analyze hooks** - First sentences reveal attention strategy
- **Study transitions** - How do ideas connect?
- **Examine conclusions** - What's the signature close?
- **Note formatting** - Headers, bullets, bold usage

### From Social Media

Social content shows engagement voice:

- **Opening hooks** - How is scrolling stopped?
- **Thread structure** - How are ideas chunked?
- **Engagement prompts** - Questions, CTAs
- **Community signals** - In-group references

## Voice Matching Checklist

Before generating content, verify:

- [ ] Vocabulary matches profile (no words from "avoid" list)
- [ ] Sentence rhythm matches (length, variety)
- [ ] Opening style matches learned pattern
- [ ] Tone is consistent (formality, warmth)
- [ ] Frameworks/analogies are in-character
- [ ] CTA style matches preference

## Memory Storage Schema

Store voice patterns with these categories:

```
Categories: ["voice-profile", "<dimension>"]

Dimensions:
- "lexical" - Word choice patterns
- "syntactic" - Sentence structure
- "rhetorical" - Persuasion patterns
- "tonal" - Emotional coloring
- "structural" - Organization patterns
- "topic-specific" - Voice variations by subject
- "platform-specific" - Voice variations by channel
```

## Voice Injection for Content Generation

When generating content in user's voice:

1. **Load Profile**
   ```
   Recall voice-profile patterns from memory
   ```

2. **Apply Constraints**
   - Use vocabulary from profile
   - Match sentence structure patterns
   - Apply tonal settings
   - Follow structural preferences

3. **Verify Match**
   - Read output aloud mentally
   - Check against "avoid" list
   - Confirm opening/closing match patterns

4. **Note Deviations**
   - If topic requires different voice, note it
   - Flag for user review if uncertain

## Platform-Specific Voice Adjustments

### LinkedIn
- Slightly more formal
- Professional but personable
- Thought leadership framing
- Engagement-focused endings

### Twitter/X
- More casual, punchy
- Thread-optimized structure
- Hook-heavy openings
- Community engagement signals

### Blog/Long-form
- Full voice expression
- Story-driven when appropriate
- Technical depth as needed
- Signature frameworks

### Email
- Direct and action-oriented
- Relationship-appropriate formality
- Clear next steps

## Common Voice Pitfalls

1. **Over-formalizing** - AI tendency to sound corporate
2. **Losing quirks** - Removing personality for "polish"
3. **Inconsistent tone** - Shifting formality mid-piece
4. **Wrong jargon** - Using terms outside their vocabulary
5. **Generic CTAs** - Not matching their engagement style

## Voice Evolution

Voice changes over time. Periodically:

- Analyze recent content (last 90 days)
- Compare to older profile entries
- Update patterns that have shifted
- Archive outdated patterns (don't delete)
