---
name: webfluence
description: Content web architecture framework. Use when diagnosing offer doc usage, content-to-conversion pathways, or why someone isn't getting sales despite traffic.
allowed-tools: Read, Glob, Grep
---

# Webfluence

## What This Does

Provides the Webfluence framework for architecting a content web that builds belief before asking for the sale. Use this to diagnose and fix content-to-conversion pathway problems.

## The Core Problem This Solves

People send prospects directly to offer docs, VSLs, or sales pages without warming them up first. The offer doc is a closing tool, not a selling tool. Without sufficient "time on brand," conversion fails.

## The Golden Rule

**Nobody sees the offer doc without seeing content and a warming-up VSL before it, or they've come through a paid workshop or event.**

The proper sequence is:
```
Content → VSL → Offer Doc
    OR
Workshop/Event → Offer Doc
```

Skipping steps = asking the offer doc to do work it wasn't built for.

## The 47-Minute Rule

Research showed buyers consumed approximately 47 minutes of content before saying yes. Use this as a filter: "Is my web architected to deliver enough time on brand before asking for the sale?"

## The Core Principle

> When marketing builds belief, persuasion becomes unnecessary.

If your content does the heavy lifting, sales calls become easy (or unnecessary). Prospects arrive pre-sold, feeling like hot referrals.

## The Five Layers of a Content Web

### Layer 1: CORE (Center)
- **Purpose:** Converts belief into buying intent
- **Example:** VSL, paid workshop
- **Function:** Your 24/7 salesperson that sells while you sleep

### Layer 2: MIDDLE RING
- **Purpose:** Builds authority and connection
- **Example:** YouTube long-form, podcast, in-depth email sequences
- **Function:** Deepens belief and establishes expertise

### Layer 3: OUTER RING
- **Purpose:** Drives reach and awareness
- **Example:** Short-form content (Instagram Reels, LinkedIn posts)
- **Function:** Entry points that create reach and recall

### Layer 4: CONNECTORS
- **Purpose:** Links everything together
- **Examples:** ManyChat automations, GPT tools, email campaigns
- **Function:** Qualifies and nurtures leads, moves traffic between layers

### Layer 5: COMPOUNDER
- **Purpose:** Keeps everything evergreen
- **Example:** YouTube channel as long-tail belief machine
- **Function:** When someone discovers one video, they binge the entire channel

## Scoring a Content Web (Out of 5)

| Layer | Question |
|-------|----------|
| **Coverage** | Do you have content for cold, warm, and hot audiences? |
| **Consistency** | Do you show up rhythmically? (Not frequency, consistency) |
| **Conversion** | Does every piece of content have a clear CTA leading somewhere? |
| **Connection** | Does every piece physically link to another? |
| **Belief Flow** | Does your content build belief, not just awareness? |

The two lowest-scoring areas are usually where the problem lives.

## Common Diagnostic Patterns

### Pattern: "Sent to offer doc, no sales"
**Diagnosis:** Skipping steps. Email → Offer doc bypasses content and VSL.
**Fix:** Content → VSL → Offer doc. The email's job is to get them to content, not the offer doc.

### Pattern: "High opens, low clicks, no sales"
**Diagnosis:** Missing connectors + possible list-offer mismatch.
**Fix:** Check if CTAs drive to content that builds belief. Check if audience matches offer.

### Pattern: "They watched the VSL but didn't apply"
**Diagnosis:** Insufficient belief-building before VSL, or VSL itself needs work.
**Fix:** More content touchpoints before VSL. Review VSL for belief-building elements.

### Pattern: "I don't have long-form content"
**Response:** You don't need all layers immediately. Start with what you have:
- At minimum: Short-form + Email + Chat automation
- YouTube/podcast can come later
- Focus on connecting existing content before creating new

## Implementation Priority

Don't try to build everything at once. Million Dollar Coach built this over 18+ months:

1. **Brand Width first** - Repurpose existing content, extend indoctrination sequences
2. **Email consistency** - Daily or regular rhythm (first cycles will be rough, that's normal)
3. **Short-form content** - With clear CTAs to tools or longer content
4. **Paid workshop** - Eliminates freebie chasers, builds belief
5. **VSL** - Your 24/7 salesperson
6. **Long-form (YouTube)** - The compounder that creates binge behavior

## Key Mindset Shifts

- **From volume to connection:** Goal isn't more content, it's connecting what you have
- **From linear to web:** Accept that buyers won't follow your planned path
- **From attribution to attention:** Stop obsessing over tracking; measure time on brand
- **From perfect to consistent:** First attempts will suck; keep exercising the muscle

## Related Trainings

Point members to these for deeper dives:
- **Brand Width** - The foundational concept of time on brand
- **Salesless Experiment** - Proof that marketing can replace sales calls
- **The System 2025** - The tactical ladder showing all the pieces
- **80-20 Content Strategy** - Content pillars and structure
- **The Social System** - How to turn stories into content
- **VSL Training** - How to create your video sales letter

## When Answering Questions

1. Identify where they are in the web architecture
2. Diagnose which layer or connection is broken
3. Prescribe the specific fix (not the whole system)
4. Point to relevant training if they need to go deeper

Remember: The offer doc is a closing tool. If someone's sending cold traffic directly to it, that's the problem.
