---
name: wechat-article-formatting
description: Convert Markdown content to WeChat Official Account HTML format with inline styles. Generates complete HTML preview files that can be copied directly to WeChat editor. Use when user needs to format articles for WeChat Official Account or mentions converting Markdown to WeChat HTML.
license: MIT
metadata:
  author: hbrls
  version: "1.0.0"
---

# 微信公众号文章排版

## 技能说明

AI 直接将 Markdown 格式的内容转换为符合微信公众号规范的 HTML 排版，无需额外脚本或工具。

## 适用场景

- 在 VSCode 中使用 Markdown 编写公众号文章
- 需要统一的文章排版样式
- 需要自定义字体、颜色、行距等样式
- 提高公众号文章编写和发布效率

## 使用流程

1. **编写 Markdown**：在 VSCode 中按照正常 Markdown 语法编写
2. **请求转换**：直接将 Markdown 内容给 AI，说明需要转换为微信公众号 HTML
3. **AI 生成预览**：AI 生成完整的 HTML 预览文件（可在浏览器中查看效果）
4. **本地预览**：在浏览器中打开生成的 HTML 文件，查看 375px 宽度下的效果
5. **自定义样式**（可选）：如需调整样式，可明确告诉 AI 具体要求（如字体大小、颜色等）
6. **复制粘贴**：在浏览器中选中内容区域（不包括灰色背景），复制后粘贴到微信公众号后台
7. **上传图片**：在公众号后台手动上传图片替换占位符（如 `[图片：xxx]`）
8. **最终确认**：在公众号后台预览并根据需要微调，确认样式无误后发布

## 核心原理

### 1. 内容载体：HTML（而非纯文本 / Markdown）

微信公众号后台最终接收和渲染的是 HTML 片段：
- 编辑器设置的字体、颜色、行距，本质上是生成对应的 HTML 行内样式
- 复制粘贴外部内容时，系统会自动解析 HTML 结构，再进行"清洗"后展示

### 2. 样式限制：微信的"白名单"规则

微信会过滤大部分自定义样式，只保留有限的标签和样式：

**✅ 支持的标签：**
- 基础标签：`p`、`div`、`span`、`img`、`a`
- 标题标签：`h1`-`h6`
- 列表标签：`ul`、`ol`、`li`
- 引用标签：`blockquote`

**✅ 支持的行内样式：**
- `color` - 文字颜色
- `font-size` - 字体大小
- `text-align` - 文本对齐
- `line-height` - 行高
- `margin`/`padding` - 外边距/内边距（有限）

**❌ 被过滤的内容：**
- 外部 CSS（`<style>` 标签）
- `<script>` 标签
- 复杂选择器
- 自定义字体
- `position: fixed` 等定位属性

### 3. 复制粘贴的本质：HTML 片段的解析与清洗

从外部复制内容粘贴到公众号后台时：
1. 系统读取剪贴板中的 HTML 富文本数据
2. 自动过滤不支持的标签/样式
3. 在编辑器中渲染可视化效果

### 4. 样式约束与实现要点

**样式约束**：
- 仅使用基础样式
- 优先使用行内样式
- 避免使用微信不支持的 CSS 属性
- 复杂样式会被微信过滤

**实现要点**：
- 排版本质是编辑符合其规则的 HTML 片段（行内样式 + 白名单标签）
- AI 可以直接理解 Markdown 并生成符合规范的 HTML，无需额外工具
- 关键要点：使用行内样式，遵循白名单规则，图片需手动上传到微信服务器

## 资源文件

### 样式.md

**路径**: `assets/样式.md`

**用途**: 微信公众号默认样式配置文件

**说明**:
- 包含所有默认样式的详细配置，包括基础文本、标题、强调、引用、代码、列表、链接、分隔线、表格等样式
- 样式基于真实微信公众号文章分析得出，符合微信公众号的阅读习惯
- AI 在转换 Markdown 时会参考此文件中的样式配置

**使用方式**:
- AI 转换时自动应用这些样式
- 用户如需自定义样式，可参考此文件中的配置项
- 用户可以在请求转换时明确指定样式调整（如"使用更大的字体"、"改变标题颜色"等）

### 预览.html

**路径**: `assets/预览.html`

**用途**: HTML 预览文件的基础模板

**说明**:
- **预览容器宽度**：375px（模拟手机屏幕宽度，对应设计稿 750px 的 2 倍图）
- **背景色**：#f5f5f5（模拟微信阅读环境）
- **内容区域**：白色背景，带阴影，模拟公众号文章卡片
- **滚动方式**：自然滚动，无需模拟手机高度
- **内边距**：内容区域 20px 内边距，保持舒适的阅读边距

**使用方式**: AI 在转换 Markdown 时，读取此模板文件，将转换后的内容插入到 `<div class="content">` 标签内

### 示例.md

**路径**: `assets/示例.md`

**用途**: 完整的 Markdown 示例文件

### 示例.html

**路径**: `assets/示例.html`

**用途**: 示例文章的 HTML 预览文件，展示所有排版元素的效果

**包含元素**: 多级标题、段落、引用块、列表、强调、链接、代码、图片占位符、分隔线、表格、混合内容排版

**使用方式**: 用户可以参考这个示例文件来编写自己的文章，或者直接基于它进行修改

## AI 转换指令

当用户请求转换 Markdown 到微信公众号 HTML 时，AI 应该：

1. **读取样式配置**：从 `assets/样式.md` 读取默认样式配置
2. **读取模板文件**：从 `assets/预览.html` 读取 HTML 模板
3. **处理 Frontmatter**：
   - 如果 Markdown 文件包含 frontmatter（`---` 包围的 YAML 元数据）
   - 提取 `title` 字段用于 HTML 的 `<title>` 标签
   - 不要在正文中重复显示 frontmatter 中的 title
   - frontmatter 仅用于 HTML meta 信息，不体现在文章正文中
4. **转换 Markdown 内容**：将 Markdown 转换为带行内样式的 HTML 片段，应用 style.md 中的样式
5. **section 包裹**：h2 和 h5 是文章的区域分割点，每个 h2 或 h5 及其后续内容（直到下一个 h2 或 h5）形成一个独立的 `<section>`
   - 每个 `<section>` 内有且仅有一个 h2，或有且仅有一个 h5
   - 每个 `<section>` 需要在 `style` 属性中设置 `font-family` 和 `font-size`，具体值参考 `assets/样式.md` 中的字体配置
   - h2 用于一级标题（如"前言"、"定价对比"），h5 用于参考资料等小节标题
   - 具体标题样式配置参考 `assets/样式.md`
   - font-family 和 font-size 必须使用行内样式，因为外部 CSS 会被微信过滤
6. **插入到模板**：将转换后的内容插入到模板的 `<div class="content">` 标签内
7. **使用行内样式**：内容区域的所有样式必须写在 HTML 标签的 `style` 属性中
8. **遵循白名单规则**：只使用微信支持的标签和样式属性
9. **保持简洁**：避免过度嵌套和复杂结构
10. **图片占位**：将 Markdown 图片转为文本占位符（如 `[图片：xxx]`）
11. **定场诗处理**：文章顶部的第一个 blockquote（位于第一个 h2 标题之前）应视作定场诗
    - 定场诗与普通 blockquote 使用不同的样式，需要单独识别和处理
    - 定场诗通常位于第一个 section 的开头，在第一个 h2 标题之前
    - **引号处理**：定场诗需要在开头和结尾添加中文引号，引号样式为浅灰色（#888888）和较大字号（20px）
    - 开头引号格式：`<span style="color: #888888; font-size: 20px;">"</span>`
    - 结尾引号格式：`<span style="color: #888888; font-size: 20px;">"</span>`
    - 具体样式配置参考 `assets/样式.md` 中的定场诗样式
    - 如果文章开头没有 blockquote，则无需处理
12. **参考资料链接**：文章结尾 h5 参考资料区的链接需转为纯文本格式，标题保持默认颜色，URL 使用浅灰色并加下划线
    - 布局：使用一个连续的 `<ol>` 包裹所有参考资料，每个 `<li>` 包含标题，标题下方嵌套一个 `<ul>` 包含对应的 URL
    - 结构：`<ol><li>标题1<ul><li>URL1</li></ul></li><li>标题2<ul><li>URL2</li></ul></li></ol>`
    - 具体样式配置参考 `assets/样式.md` 中的参考资料链接样式
13. **正文链接**：正文中不应出现链接，如需引用外部资源，建议在文中用纯文字提及

## 注意事项

- **图片处理**：微信公众号无法直接引用外部图片，AI 会将图片转为占位符（如 `[图片：xxx]`），需在后台手动上传替换
- **链接处理**：微信不支持内嵌超链接，参考资料区的链接需转为纯文本格式，标题用默认颜色，URL 用浅灰色加下划线。使用连续的 `<ol>` 包裹所有参考资料，每个 `<li>` 内嵌套 `<ul>` 显示 URL。具体样式参考 `assets/样式.md`
- **正文链接**：正文中不应出现链接，如需引用外部资源，建议在文中用纯文字提及
- **样式测试**：粘贴后务必使用公众号后台的"预览"功能，检查在手机端的显示效果
- **复制范围**：只复制白色内容区域，不要包含灰色背景部分
