# 微信公众号默认样式配置

## 基础文本样式
```css
字体大小：16px（正文）
行高：1.8em
段落间距：padding: 8px 0
文字颜色：#000000
```

## 字体配置
```css
section 字体：
  font-size: 16px
  font-family: Optima-Regular, Optima, PingFangSC-light, PingFangTC-light, "PingFang SC", Cambria, Cochin, Georgia, Times, "Times New Roman", serif

p 段落：
  line-height: 1.8em
  padding: 8px 0
  color: #000000
```

## 背景样式
```css
section 方形底纹背景：
  background-image: linear-gradient(90deg, rgba(50, 0, 0, 0.05) 0%, rgba(0, 0, 0, 0) 6.76%), linear-gradient(360deg, rgba(50, 0, 0, 0.05) 0%, rgba(249, 247, 252, 0) 9.46%)
  background-size: 20px 20px, 20px 20px
  background-repeat: repeat, repeat
```

## 标题样式
```css
一级标题（h1）：
  /* 本次文章未使用 h1 */

二级标题（h2）：
  font-size: 20px
  font-weight: bold
  color: #2584b5 (蓝色主题色)
  margin: 30px 0 15px
  padding-bottom: 10px
  text-align: center

二级标题内的 span：
  display: inline-block
  border-bottom: 2px solid #2584b5
  padding-bottom: 10px

标题装饰图标（em）：
  左边图标：
    margin: 9px 10px 0px 0px
    width: 12px
    height: 8px
    display: inline-block
    vertical-align: top
    background-image: url('https://mmbiz.qpic.cn/mmbiz_png/b2YlTLuGbKB4HdzrPpCLXPgr0YSI9PtniacH2wIEQiaGKGSkv8zJ3kpLXxtlgx1WMmP8NIteXVuibH7voQOVVAw3w/640?wx_fmt=png')
  右边图标：
    margin: 8px 0px 0px 10px
    width: 12px
    height: 11px
    display: inline-block
    vertical-align: top
    background-image: url('https://mmbiz.qpic.cn/mmbiz_png/b2YlTLuGbKB4HdzrPpCLXPgr0YSI9Ptnp8N2s4IUpffNFAMrHVcuDQCwCDUD1PW5glhyIs8wd1RH8wYkrUwyeg/640?wx_fmt=png')

三级标题（h3）：
  /* 本次文章未使用 h3 */

四级标题（h4）：
  /* 本次文章未使用 h4 */

五级标题（参考资料）：
  font-size: 20px
  font-weight: bold
  color: rgb(0, 179, 138) (绿色主题色)
  margin: 20px 0 10px
  text-align: center

五级标题内的 span：
  display: inline-block
  border-bottom: 2px solid rgb(0, 179, 138)
  padding-bottom: 10px

六级标题（h6）：
  /* 本次文章未使用 h6 */
```

## 强调样式
```css
强调文字：
  color: rgb(239, 112, 96)
  font-weight: bold
  background: none

加粗：font-weight: bold
斜体：font-style: italic
```

## 引用样式
```css
普通引用块（blockquote）：
  背景色：#f7f7f7
  左边框：4px solid #ddd
  内边距：10px 15px
  外边距：10px 0
  行高：1.8em

定场诗（第一个 blockquote，位于第一个 h2 之前）：
  /* 定场诗样式待定，后续调整 */
  /* 与普通引用块使用不同的样式，需要单独处理 */
  /* 定场诗通常用于文章开头，起到点题或营造氛围的作用 */
  
定场诗引号：
  开头引号：<span style="color: #888888; font-size: 20px; margin-left: -0.5em;">“</span>
  结尾引号：<span style="color: #888888; font-size: 20px; margin-right: -0.5em;">”</span>
  说明：定场诗需要在开头和结尾添加中文引号，引号使用浅灰色（#888888）和较大字号（20px），左引号使用 margin-left: -0.5em 悬挂在左侧，右引号使用 margin-right: -0.5em 悬挂在右侧
```

## 代码块样式
```css
背景色：#f5f5f5
字体：Consolas, Monaco, monospace
内边距：10px
边框：1px solid #e0e0e0
边框圆角：4px
行内代码：background-color: #f5f5f5, padding: 2px 6px
```

## 列表样式
```css
列表项间距：margin: 5px 0
列表外边距：margin: 8px 0
列表内边距：padding-left: 25px
行高：1.8em
```

## 链接样式
```css
颜色：#576b95 (微信蓝)
文字装饰：none
```

## 分隔线样式
```css
<hr> 标签：
  border: none
  border-top: 1px solid #e0e0e0
  margin: 15px 0

或使用 div：
  height: 1px
  background-color: #e0e0e0
  margin: 15px 0
```

## 表格样式
```css
表格：
  border-collapse: collapse
  width: 100%
  margin: 10px 0
  font-size: 16px
  line-height: 1.8em

表头（th）：
  border: 1px solid #e0e0e0
  padding: 8px
  background-color: #f7f7f7
  text-align: left

单元格（td）：
  border: 1px solid #e0e0e0
  padding: 8px
```

## 参考资料链接样式
```css
参考资料区（ol）：
  margin: 10px 0
  padding-left: 20px

参考资料标题（ol > li）：
  line-height: 1.8em
  margin: 8px 0

参考资料链接区（ol > li > ul，嵌套在 li 内部）：
  margin: 0
  padding-left: 0
  list-style: none

参考资料链接（ol > li > ul > li）：
  line-height: 1.8em
  margin: 4px 0
  color: #888888
  text-decoration: underline
```
