# 微信公众号排版示例文章

这是一篇包含各种常见排版元素的示例文章，用于演示 Markdown 到微信公众号 HTML 的转换效果。

## 前言

本文档展示了微信公众号文章的各种排版元素，包括标题、段落、引用、列表、强调、代码、分隔线和表格等。

## 二级标题示例

正文段落示例。这是一段普通的正文内容，用于展示基础的文本排版效果。段落之间会有适当的间距，行高设置为 1.8em，确保良好的阅读体验。

这是第二段正文内容。段落与段落之间保持一致的间距，字体大小继承自 section，颜色为 #000，符合微信公众号的阅读习惯。

> 这是一段引用内容。引用块通常用于引用他人的话语、重要的提示信息或需要特别强调的内容。
>
> 引用块可以包含多个段落，每个段落都会保持引用样式。

> 这是另一个独立的引用块，用于展示引用块之间的间距效果。

## 强调和加粗

这段文字包含**加粗内容**和*斜体内容*，还有***加粗斜体内容***。

使用加粗可以**突出重点**，使用斜体可以*表示强调*。

## 列表示例

无序列表：

- 列表项 1：这是第一个列表项
- 列表项 2：这是第二个列表项
- 列表项 3：这是第三个列表项，内容较长时会自动换行，保持与列表标记的对齐关系
- 列表项 4：最后一个列表项

有序列表：

1. 第一步：准备工作
2. 第二步：开始执行
3. 第三步：检查结果
4. 第四步：完成收尾

## 代码示例

行内代码示例：`console.log('Hello World')`

代码块示例：

```javascript
function greeting(name) {
  console.log(`Hello, ${name}!`);
}

greeting('World');
```

## 分隔线

---

分隔线用于分隔不同的内容区块。

---

## 表格示例

| 功能 | 说明 | 状态 |
|------|------|------|
| 标题 | 支持 h1-h6 | ✅ |
| 段落 | 基础文本内容 | ✅ |
| 列表 | 有序/无序列表 | ✅ |

## 参考资料

1. 微信公众平台官方文档: https://developers.weixin.qq.com
2. Markdown 基本语法说明: https://www.markdownguide.org
