---
name: weekly-news-metadata
description: 週刊テックニュース動画のYouTubeメタデータ（タイトル・概要欄・ハッシュタグ）を生成するスキル。「週刊ニュースを作成して」「週刊テックニュースを作りたい」などのリクエストで利用。
---

# YouTube Weekly News Metadata Creator Skill

週刊テックニュース動画のYouTubeメタデータ（タイトル・概要欄・ハッシュタグ）を生成するスキルです。

## 使い方

このスキルはプラグインとして提供されており、特定のディレクトリ構造に依存しません。任意のプロジェクトで使用できます。

### スキルの起動方法

ユーザーが以下のようなリクエストをした場合、このスキルを起動してください：
- 「週刊ニュースを作成して」
- 「週刊テックニュースを作りたい」
- 「YouTubeのニュース動画を作成」

## ワークフロー

### フェーズ1: 情報収集

1. **対象週を確認**
   ```
   週刊ニュースを作成します！対象週を教えてください。
   例：2025年11月第2週、11/11-11/17、2025-11-11など
   ```

2. **ニュース情報を収集**
   - ニュース項目（タイトルと要約）
   - 特に注目すべきトピック
   - 動画の長さ

### フェーズ2: YouTubeメタデータ生成

3. **コンテンツ分析**
   - ニュースの重要度ランキング
   - トレンド性（話題性の高さ）
   - 実務への影響度（エンジニアの仕事に直結するか）
   - キャッチーな表現の抽出

4. **YouTubeメタデータ生成**
   - **タイトル3パターン**を生成（詳細は`REFERENCE.md`参照）
   - **概要欄**を生成（タイムテーブル、おすすめ対象者など）
   - **ハッシュタグ**を10-15個生成
   - **想定コメント5つと返信**を生成（エンゲージメント向上）

## 出力フォーマット

```markdown
# 週刊テックニュースダイジェスト - YouTube メタデータ

生成日時: YYYY-MM-DD HH:MM
対象週: YYYY年MM月DD日〜

---

## タイトル案

### パターン1: 時短強調型
【5分でキャッチアップ】今週のテック&AIニュース | [注目トピック] | YYYY年MM月第N週

**狙い**: 忙しい人向けに時短性を前面に出す
**文字数**: XX文字

---

### パターン2: 網羅性強調型
忙しい人のための週刊テックニュース完全版 | [注目トピック]ほか全X本 | MM/DD-MM/DD

**狙い**: 「これだけ見れば十分」という安心感を提供
**文字数**: XX文字

---

### パターン3: トピック強調型
【週刊AIニュース】 YYYY年MM月DD日〜 | [トピック1]、[トピック2]、そして[トピック3]

**狙い**: 具体的なニュース内容で興味を引く
**文字数**: XX文字

---

## 推奨タイトル

最もクリック率が期待できるのは**パターンX**です。

**理由**: [具体的な理由を記載]

---

## 概要欄

[冒頭文: 動画の価値提案]

📰 今週のニュース一覧
00:00 イントロ
00:30 ① [ニュース1のタイトル]
...

🎯 こんな人におすすめ
✅ 最新のテック&AIニュースをキャッチアップしたいエンジニア
...

📱 SNS
・ブログ: https://masayablog.com
・Twitter: @masayan_software_dev

#[ハッシュタグ]

---

## ハッシュタグ一覧

**汎用系:**
- #テックニュース
- #AIニュース
- #エンジニア

**トピック系:**
- #[ニュース関連キーワード]

**視聴者属性系:**
- #駆け出しエンジニアと繋がりたい

**推奨ハッシュタグ（コピペ用）:**
#テックニュース #AIニュース #エンジニア #[その他] ...

---

## 想定コメント・返信

### 1. ニュースへの驚きのコメント
【コメント】
[特定のニュースへの驚きや興味を示すコメント]

【返信】
[共感を示し、さらなる情報提供や対話を促す返信]

...
```

## 参考資料

- **TEMPLATE.md**: ドラフトファイルのテンプレート
- **REFERENCE.md**: タイトル戦略、ハッシュタグ戦略、概要欄テンプレート
- **references/title-examples.md**: タイトル例
- **references/description-templates.md**: 概要欄テンプレート
- **references/hashtag-strategy.md**: ハッシュタグ戦略

## 注意事項

- ニュース内容の正確性を確認（虚偽情報は厳禁）
- 偏った視点を避け、中立的な情報提供を心がける
- タイトルは煽りすぎず、誠実な印象を保つ
- 概要欄は視聴者が求める情報に素早くアクセスできる構成にする
