# 週刊テックニュースダイジェスト - ハッシュタグ戦略

## ハッシュタグの基本戦略

### 目的
1. **検索性向上**: よく検索されるキーワードで発見されやすく
2. **カテゴリ明示**: 動画の内容を端的に示す
3. **ターゲット訴求**: 視聴者層にリーチする
4. **トレンド参加**: 話題のトピックに乗る

### 推奨数
- **合計**: 10-15個
- **最小**: 8個（必須タグのみ）
- **最大**: 20個（情報過多にならない範囲）

---

## ハッシュタグの3層構造

### 第1層: 汎用系タグ（必須）
どの週刊ニュース動画にも必ず含めるベースタグ

#### 必須タグ（3-4個）
```
#テックニュース
#AIニュース
#エンジニア
#週刊ダイジェスト
```

#### 推奨追加タグ（2-3個から選択）
```
#プログラミング
#IT業界
#テクノロジー
#開発者
```

---

### 第2層: トピック系タグ（可変）
その週のニュース内容に応じて選択

#### AIモデル関連
```
#ChatGPT
#GPT4
#GPT5
#Claude
#Gemini
#LLM
#生成AI
#OpenAI
#Anthropic
#Google
#機械学習
```

#### 開発ツール関連
```
#GitHub
#VSCode
#Cursor
#Docker
#GitHubCopilot
#開発ツール
#生産性向上
```

#### 言語・フレームワーク関連
```
#JavaScript
#TypeScript
#Python
#React
#Nextjs
#Node.js
```

---

### 第3層: 視聴者属性系タグ
ターゲット層にリーチするためのタグ

#### エンジニアコミュニティ系
```
#駆け出しエンジニアと繋がりたい
#エンジニアと繋がりたい
#プログラミング初心者
```

#### キャリア・職種系
```
#フルスタックエンジニア
#フロントエンドエンジニア
#バックエンドエンジニア
#AIエンジニア
```

---

## トピック別ハッシュタグセット

### AI特化週（GPT-5発表など）
```
汎用系（4個）:
#テックニュース #AIニュース #エンジニア #週刊ダイジェスト

トピック系（7個）:
#GPT5 #OpenAI #ChatGPT #Claude #Gemini #LLM #生成AI

視聴者属性系（4個）:
#エンジニアと繋がりたい #AIエンジニア #プログラミング #機械学習

合計: 15個
```

### 開発ツール特化週
```
汎用系（4個）:
#テックニュース #エンジニア #開発ツール #週刊ダイジェスト

トピック系（7個）:
#GitHub #GitHubCopilot #VSCode #Cursor #コーディング支援 #生産性向上 #AI開発

視聴者属性系（4個）:
#エンジニアと繋がりたい #フルスタックエンジニア #プログラマー #開発者

合計: 15個
```

### 総合ニュース週
```
汎用系（4個）:
#テックニュース #AIニュース #エンジニア #週刊ダイジェスト

トピック系（8個）:
#ChatGPT #GitHub #VSCode #Python #Docker #クラウド #セキュリティ #Web開発

視聴者属性系（3個）:
#エンジニアと繋がりたい #フルスタックエンジニア #IT業界

合計: 15個
```

---

## NGハッシュタグ（避けるべき）

### 1. 無関係なタグ
```
❌ #料理 #旅行 #ファッション
```

### 2. スパムと見なされるタグ
```
❌ #フォロバ100 #相互フォロー #いいね返し
```

### 3. 一般的すぎるタグ
```
❌ #video #youtube #content
```

---

## ハッシュタグの配置戦略

### 概要欄での配置位置

**推奨: 概要欄の中盤**
```markdown
[冒頭文]
[タイムテーブル]
[おすすめ対象]
[動画情報]
[SNSリンク]

#ハッシュタグ1 #ハッシュタグ2 #ハッシュタグ3...

---
[著者プロフィール]
[CTA]
```

### 表示形式

**推奨: スペース区切り**
```
#テックニュース #AIニュース #エンジニア #週刊ダイジェスト #ChatGPT
```

---

## ハッシュタグテンプレート（コピペ用）

### テンプレート1: AI特化
```
#テックニュース #AIニュース #エンジニア #週刊ダイジェスト #ChatGPT #Claude #Gemini #OpenAI #Anthropic #Google #LLM #生成AI #AI開発 #機械学習 #プログラミング
```

### テンプレート2: 開発ツール特化
```
#テックニュース #エンジニア #開発ツール #週刊ダイジェスト #GitHub #VSCode #Cursor #GitHubCopilot #コーディング支援 #生産性向上 #AI開発 #プログラミング #開発環境 #フルスタックエンジニア
```

### テンプレート3: 総合版
```
#テックニュース #AIニュース #エンジニア #週刊ダイジェスト #ChatGPT #GitHub #VSCode #Python #Docker #Web開発 #フルスタックエンジニア #プログラミング #IT業界 #生産性向上
```

---

## まとめ: ハッシュタグ選定の5原則

1. **関連性**: 動画内容と必ず関連するタグのみ使用
2. **検索性**: よく検索されるキーワードを優先
3. **適量**: 10-15個が最適（多すぎず少なすぎず）
4. **バランス**: 汎用系・トピック系・属性系の3層バランス
5. **鮮度**: トレンドを反映し、定期的に見直す
