---
name: win-the-day
description: Morning routine facilitator. Guides Ed through metrics, capture triage, and task clarity. Use at start of day with "win the day", "morning routine", "start my day", "let's get at it".
allowed-tools: Read, Write, Edit, Glob, Grep, Bash, AskUserQuestion
---

# Win The Day

Ed's morning routine - metrics briefing, email triage, capture processing, and task clarity in one guided flow.

## Philosophy

This is a **facilitator workflow**, NOT an autonomous agent.

- Ed is in front of the computer, actively participating
- Each step presents information or options
- **Ed makes all decisions** - you orchestrate, Ed approves
- Interactive by design - questions and approvals are features, not friction
- Keep it fast - Ed is watching, minimize latency

This is NOT a "fire and forget" background process. It's a guided morning routine.

## The Pipeline

Run these steps in sequence. Each step invokes a sub-skill that handles the details.

```
Step 0 (Optional): X Bookmarks
Step 1: Morning Metrics
Step 2: Inbox Triage (Email)
Step 3: Process Captures
Step 4: Clarify Tasks
Step 5: Consolidated Summary
```

---

### Step 0: External Input Sources (Optional)

Before processing captures, ask about external input sources:

"Do you want to fetch X bookmarks first? (They'll land in Inbox for triage)"

Options:
- **Yes** - Invoke the **x-bookmarks** skill, wait for completion
- **No** - Skip to Step 1
- **Already done** - Skip (user ran it manually)

The x-bookmarks skill fetches Twitter bookmarks and drops them as .md files in Inbox. Capture-triage will pick them up in Step 3.

**Automation mode:** Skip unless explicitly requested ("win the day with X bookmarks").

---

### Step 1: Morning Metrics

Invoke the **morning-metrics** skill to get the lay of the land.

Say: "Pulling your morning metrics..."

The skill handles:
- **Calendar** (today's meetings + tomorrow preview)
- **Gmail** unread counts + important emails
- **iCloud** unread counts

Wait for the skill to complete. Capture its output for the final summary:
- Email counts (Gmail + iCloud)
- Meeting count + list
- Any urgent flags (meetings in next 2 hours, important emails)

Present the metrics summary.

**BB Call Detection:**

After morning-metrics completes, check the calendar events for BlackBelt coaching calls:

1. Scan the events list from morning-metrics output
2. Look for BB call patterns:
   - Title contains "and Ed Dale"
   - Title contains "Blackbelt Game Plan Call"
   - Description contains "The 20 with Ed"
3. Exclude non-coaching events:
   - Kickoff calls
   - Group calls
   - Travel calls

**If BB calls found:**

Say: "You have [N] BlackBelt calls today. Let me prep those..."

Invoke the **bb-call-prep** skill. It will:
- Fetch each client's Basecamp history
- Generate prep cards with check-in points
- Save to Zettelkasten and link in daily note

Wait for bb-call-prep to complete. Capture for final summary:
- Number of BB calls
- Client names and times
- Link to prep document

**If no BB calls found:** Continue to Step 2 without mentioning BB prep.

---

### Step 2: Inbox Triage (Email)

Invoke the **inbox-summary** skill to triage email.

Say: "Let me check your email..."

The skill:
- Fetches last 24 hours from Gmail + iCloud
- Classifies into: **Needs Attention** / **Worth Knowing** / **Filtered**
- Highlights priority senders and mission-context matches (BlackBelt, AI Powerhouse, etc.)

Present the triage summary. Ask: "Any senders to mark as priority?"

Capture for final summary:
- Attention count
- Key items flagged
- Any priority sender changes

**Automation mode:** Run fully, skip "mark as priority" prompt.

---

### Step 3: Process Captures

Invoke the **capture-triage** skill to process the Drafts inbox.

Say: "Now let's triage your captures."

The skill runs its **complete flow**:
1. Check Inbox folder for files
2. Load project context (from mission-context)
3. Read and classify each capture
4. Show classification preview table
5. Ask for approval (Approve all / Go one-by-one / Modify / Skip)
6. Route approved items to Ready section
7. Move processed files to Inbox/Processed/
8. Generate triage summary

Wait for the full flow to complete. If Inbox is empty, the skill reports "No captures waiting."

Capture for final summary:
- Items processed count
- What was routed (tasks, ideas, references)
- Any research swarms spawned

---

### Step 4: Clarify Tasks

Invoke the **task-clarity-scanner** skill to review the board.

Say: "Let's review your tasks."

The skill runs **ALL passes**:
- **PASS 0:** Kanban health check (Today's 3 count, Ready size, stale items, Waiting For)
- **PASS 1:** Clarify unclear tasks one at a time (with options to rewrite, skip, someday, etc.)
- **PASS 1.5:** Kanban swaps (if Ed wants to adjust Today's 3)
- **PASS 1.6:** Waiting For follow-up check (overdue/due items)
- **PASS 2:** Apply approved changes

**Important:** Let the skill run ALL passes, not just the health check.

Capture for final summary:
- Today's 3 status
- Stale items addressed
- Ship This = Win Day item

---

### Step 5: Morning Summary

After all steps complete, consolidate everything into a single status report:

```markdown
## Win The Day - [Date]

### Metrics
- **Email:** Gmail [X] unread | iCloud [Y] unread
- **Calendar:** [N] meetings today | [M] tomorrow
- **Urgent:** [any flags from Step 1]

### BB Calls (if coaching day)
- **Calls:** [N] coaching calls
- **Prep:** [[BB Call Prep - YYYY-MM-DD]]
- **Quick view:**
  - [Time] - [Client Name]
  - [Time] - [Client Name]

### Email Triage
- **Needs Attention:** [N] items
- **Key items:** [list top 2-3 if any]
- **Priority senders:** [N] configured

### External Inputs
- **X Bookmarks:** [N] fetched (or "skipped")

### Captures
- **Processed:** [N] items
- **Routed:** [breakdown by type: X tasks, Y ideas, Z references]

### Board Status
- **Today's 3:**
  1. [task 1]
  2. [task 2]
  3. [task 3]
- **Ready:** [N] items
- **Stale:** [N] addressed

### Ship This = Win Day
[The focus item]

---
Ready to win.
```

**Key points:**
- Pull actual numbers from each sub-skill's output
- Don't recount - use the summaries already generated
- Keep it scannable (30 seconds to absorb)
- End on the focus item

---

## Automation Mode (Optional)

Triggered by "win the day automatically" or "quick status":

This is for when Ed wants a quick snapshot, not the full guided flow.

| Step | Automation Behavior |
|------|---------------------|
| Step 0 (X Bookmarks) | Skip |
| Step 1 (Metrics) | Run fully, show summary |
| Step 2 (Inbox) | Run fully, skip "mark priority" prompt |
| Step 3 (Captures) | Report what's in Inbox (don't process) |
| Step 4 (Tasks) | PASS 0 only (board status), skip interactive clarification |
| Step 5 (Summary) | Present consolidated snapshot |

**This is NOT the default.** Default is interactive with Ed participating at every step.

---

## Trigger Phrases

- "win the day"
- "morning routine"
- "start my day"
- "let's get at it"
- "daily review"
- "win the day with X bookmarks" (includes Step 0)
- "win the day automatically" (automation mode)
- "quick status" (automation mode)

---

## Guidelines

- **Speed matters** - Ed is watching, minimize latency
- **Don't over-explain** - Brief summaries, not essays
- **Flag anomalies** - Unusually high unreads, meetings soon, stale tasks
- **Respect the flow** - Complete each step before moving on
- **Human in the loop** - Ed makes all decisions, you orchestrate
- **Sub-skills do the work** - Invoke them by name, don't replicate their logic
