# Win The Day - Roadmap

## Shipped

| Version | Date | What Changed |
|---------|------|--------------|
| v3.1 | 2026-01-16 | BB call prep integration - auto-detects coaching days and invokes bb-call-prep |
| v3.0 | 2026-01-16 | Added x-bookmarks (Step 0), inbox-summary (Step 2), fixed skill invocation pattern, explicit sub-skill flows |
| v2.0 | 2026-01-10 | Converted from agent to skill, added morning-metrics |
| v1.0 | 2026-01-08 | Original agent with capture-triage + task-clarity-scanner |

## Planned

- [x] **BB call prep integration** - ✅ v3.1 - Auto-detects coaching days from calendar, invokes bb-call-prep, surfaces client prep in summary
- [ ] Substack metrics in morning briefing (add to morning-metrics)
- [ ] Revenue snapshot (Stripe integration)
- [ ] Smart urgency detection (meetings in next hour, VIP emails)
- [ ] Weekly summary mode ("win the week")

## Ideas (Not Committed)

- Slack/Discord integration for team updates
- Weather integration (affects energy/planning)
- Focus mode suggestion based on calendar density
- "End of day" counterpart skill

## What We've Learned

### 2026-01-16 - v3.0 Sub-Skill Orchestration
- Calling Python directly in skills violates abstraction - invoke the skill by name instead
- The morning-metrics SKILL has two steps (calendar + email) - calling Python directly skipped calendar
- "Invoke skill X" is clearer than showing the bash command - Claude handles discovery
- Explicit "run ALL passes" language ensures task-clarity-scanner completes fully
- Facilitator philosophy must be stated upfront to prevent autonomous runaway
- x-bookmarks integration should be optional (Step 0) since it's slow and may have auth issues

### 2026-01-10 - Agent → Skill Conversion
- Skills execute faster than agents for interactive workflows
- The "Ed is watching" test: if latency matters, use a skill
- Sub-skill orchestration works via natural language instruction
- Python scripts for API calls, skills for workflow logic

### 2026-01-08 - Original Build
- Facilitator pattern > autonomous pattern for morning routines
- Human-in-the-loop at each step prevents runaway operations
- AskUserQuestion is essential for batch approvals

## Technical Decisions

| Decision | Rationale |
|----------|-----------|
| Skill over agent | Faster execution, less overhead for interactive work |
| Python for metrics | Clean API handling, JSON output for Claude to format |
| Sub-skill calls via instruction | Simpler than agent orchestration, Claude handles discovery |
| Automation mode | Sometimes Ed wants quick status, not full interactive flow |
