# Sentence Case for UI Text

## Table of Contents

- [Rule: Always Use Sentence Case](#rule-always-use-sentence-case)
- [Examples](#examples)
- [Exceptions](#exceptions)
- [Common UI Elements](#common-ui-elements)
- [Why Sentence Case?](#why-sentence-case)
- [Quick Reference](#quick-reference)
- [When in Doubt](#when-in-doubt)

## Rule: Always Use Sentence Case

**Always use sentence case for UI copy, not title case.**

Sentence case means only the first word and proper nouns are capitalized.

## Examples

### Correct - Sentence Case

- "Payment provider options"
- "Complete setup"
- "Add new gateway"
- "Configure payment settings"
- "Save changes"
- "View documentation"
- "Enable test mode"

### Incorrect - Title Case

- "Payment Provider Options"
- "Complete Setup"
- "Add New Gateway"
- "Configure Payment Settings"
- "Save Changes"
- "View Documentation"
- "Enable Test Mode"

## Exceptions

Sentence case has specific exceptions where capitalization is required:

### 1. Proper Nouns

Always capitalize proper nouns (names of specific products, services, or brands):

**Correct:**

- "Connect with WooPayments"
- "Import from WordPress"
- "Sync with Stripe"
- "Enable Google Analytics"

### 2. Acronyms

Always capitalize acronyms:

**Correct:**

- "Configure API settings"
- "Enter URL"
- "Set up SSL certificate"
- "Generate CSV export"

### 3. Brand Names

Always use the official capitalization for brand names:

**Correct:**

- "PayPal"
- "WooCommerce"
- "WordPress"
- "Stripe"

## Common UI Elements

### Buttons

```text
✅ Correct:
- "Save changes"
- "Add product"
- "Continue to checkout"
- "Send test email"

❌ Incorrect:
- "Save Changes"
- "Add Product"
- "Continue To Checkout"
- "Send Test Email"
```

### Labels

```text
✅ Correct:
- "Payment method"
- "Shipping address"
- "Order notes"
- "Tax rate"

❌ Incorrect:
- "Payment Method"
- "Shipping Address"
- "Order Notes"
- "Tax Rate"
```

### Menu Items

```text
✅ Correct:
- "Settings"
- "Payment gateways"
- "Tax settings"
- "Shipping zones"

❌ Incorrect:
- "Settings"  (this one is actually correct - it's a single word)
- "Payment Gateways"
- "Tax Settings"
- "Shipping Zones"
```

### Headings

```text
✅ Correct:
- "Payment settings"
- "Configure your store"
- "Advanced options"

❌ Incorrect:
- "Payment Settings"
- "Configure Your Store"
- "Advanced Options"
```

### Messages and Notifications

```text
✅ Correct:
- "Settings saved successfully"
- "Unable to connect to payment provider"
- "Please enter a valid email address"

❌ Incorrect:
- "Settings Saved Successfully"
- "Unable To Connect To Payment Provider"
- "Please Enter A Valid Email Address"
```

## Why Sentence Case?

More readable, conversational, and modern. Better for accessibility and internationalization.

## Quick Reference

| Element Type | Example |
|--------------|---------|
| Button | "Save changes" |
| Link | "View all orders" |
| Label | "Email address" |
| Heading | "Payment options" |
| Message | "Order created successfully" |
| Menu item | "Product settings" |
| Checkbox | "Enable notifications" |
| Tab | "General settings" |

## When in Doubt

Capitalize only: first word, proper nouns, and acronyms.

Example: "Enable WooPayments API integration"
