# Module 01: The Philosophy of Clarity

> **"If you can't explain it simply, you don't understand it well enough."** — _Richard Feynman_
> **"Clutter is the disease of writing. We are a society strangling in unnecessary words."** — _William Zinsser_

This module covers the _mindset_ required to write world-class technical documentation.

## 1. The Feynman Technique: Mental Models

Technical writing is not about describing features; it is about transferring a **mental model** from your brain to the reader's brain.

### 1.1 Concrete Before Abstract

The human brain (and LLMs) learns via pattern matching. We cannot grasp abstract theory without concrete anchors.

- **The Rule**: Never introduce a concept with a definition. Introduce it with an example.
- **The Flow**: `Real-World Analogy` $\rightarrow$ `Code Example` $\rightarrow$ `Technical Definition`.

> **Bad (Abstract Only)**:
> "The `UserDispatcher` implements the Observer pattern to propagate state changes."
> _(The reader has no mental image.)_

> **Good (Concrete First)**:
> "Think of the `UserDispatcher` like a radio tower. When the DJ (State) changes the song, the tower broadcasts the signal to all radios (Listeners) instantly. In code, the `UserDispatcher` notifies all subscribed components when data changes."

### 1.2 The "ELI5" Benchmark (Explain Like I'm 5)

Assume your reader is intelligent but lacks your specific context.

- **No "Easy"**: Never use words like "simply", "obviously", "just", or "basic". Nothing is simple when you are debugging it at 3 AM.
- **Define Jargon**: If you use an acronym (e.g., AST, DAG), define it effectively on first use.

---

## 2. The Zinsser Principle: Humanity

Documentation is a conversation between two humans. It should not sound like a legal contract.

### 2.1 Be a Person, Not a Corporation

- **Voice**: Write as if you are explaining the solution to a colleague over coffee.
- **Agency**: Use "We" (the team) and "You" (the reader).
  - _Corporate_: "It has been determined that the parameter is required."
  - _Human_: "You must provide this parameter."

### 2.2 The Rhythm of Writing

Good writing has a beat. It varies.

- **Short Sentences**: Use them for action and impact. "Restart the server."
- **Longer Sentences**: Use them for logic and flow. "After the server restarts, check the logs to ensure that the connection pool has initialized correctly."
- **The "Read Aloud" Test**: Read your paragraph aloud. If you stumble, or run out of breath, the rhythm is broken. Rewrite it.

### 2.3 Simplicity is Strength

Don't use big words to sound smart. Use simple words to make the reader feel smart.

- _Pretentious_: "We endeavored to facilitate the implementation."
- _Simple_: "We tried to help build it."

---

## 3. Router-Augmented Coding: The AI Pattern

The **"Static Standards + Dynamic Examples"** pattern extends Zinsser's clarity to AI code generation.

### 3.1 The Three-Layer System

| Layer            | Form                                | Purpose                                          |
| ---------------- | ----------------------------------- | ------------------------------------------------ |
| **L1: Law**      | `agent/standards/lang-*.md`         | Project-specific conventions, forbidden patterns |
| **L2: Case Law** | `tool-router/data/examples/*.jsonl` | Concrete Few-Shot examples                       |
| **L3: Enforcer** | `lang_expert` MCP tool              | Combines L1 + L2 for context injection           |

### 3.2 Why This Pattern Works

**Problem**: LLMs generate generic code that doesn't match project conventions.

```bash
# LLM generates (wrong!)
with pkgs;
mkNixago { data = { conform = {...}; }; }  # Full override!
```

**Solution**: Router-Augmented Coding

```bash
# Agent uses lang_expert
@omni-orchestrator consult_language_expert file_path="lefthook.nix" task="add hook"

# Returns: "DO NOT use with pkgs; DO NOT full override dmerge"
# Plus concrete example from tool-router
```

### 3.3 Writing Standards for AI

When writing `agent/standards/lang-*.md` files:

1. **Forbidden Patterns First**: List what NOT to do (e.g., "❌ `with pkgs;`")
2. **Concrete Examples**: Show before/after for each pattern
3. **Project Conventions**: Document your unique choices (mkNixago, dmerge, etc.)

This follows Feynman: Example → Theory. The LLM sees the pattern first, then the rule.
