---
name: writing-assistant
description:
  Work on writing assistance features including real-time style analysis,
  grammar checking, writing goals tracking, inline suggestions, and writing
  analytics. Use when implementing linguistic analysis, productivity tracking,
  or writing quality tools.
---

# Writing Assistant

## Quick Reference

- **[Style Analysis](style-analysis.md)** - Voice consistency and tone detection
- **[Grammar System](grammar-system.md)** - Suggestions and error detection
- **[Goals Tracking](goals-tracking.md)** - Targets, streaks, and achievements
- **[Writing Analytics](writing-analytics.md)** - Metrics and productivity
  insights

## When to Use

- Implementing real-time style or tone analysis
- Building grammar checking or suggestion systems
- Creating writing goals or productivity tracking
- Working on inline suggestions or feedback
- Analyzing writing patterns or metrics
- Detecting voice consistency issues

## Core Methodology

- **Linguistic Analysis**: Apply NLP patterns for style and grammar
- **Real-time Processing**: Analyze text efficiently as user types
- **Goal Tracking**: Use gamification for motivation and progress
- **Feedback Quality**: Provide actionable, context-aware suggestions
- **Performance**: Optimize for responsive real-time analysis

## Integration

- **tech-stack-specialist**: Manage NLP libraries and analysis tools
- **qa-engineer**: Test linguistic accuracy and edge cases
- **performance-engineer**: Optimize real-time analysis performance
- **architecture-guardian**: Separate analysis logic from UI
- **domain-expert**: Model writing concepts and metrics

## Best Practices

✓ Provide explanations for all suggestions ✓ Maintain user preferences and
writing style profile ✓ Use debouncing for real-time analysis ✓ Cache analysis
results where appropriate ✓ Support multiple writing styles and genres

## Content Modules

See detailed modules:

- **[Style Analysis](style-analysis.md)**: Voice, tone, and consistency
  detection
- **[Grammar System](grammar-system.md)**: Error detection and suggestions
- **[Goals Tracking](goals-tracking.md)**: Daily targets, streaks, achievements
- **[Writing Analytics](writing-analytics.md)**: Metrics, patterns, insights
- **[Inline Suggestions](inline-suggestions.md)**: Real-time feedback
  implementation
