# Economical Writing - Extended Reference

Based on Deirdre McCloskey's *Economical Writing* (3rd edition, University of Chicago Press).

## Extended Bad Words List

### Vague Nouns with Alternatives

| Avoid | Use Instead | Notes |
|-------|-------------|-------|
| concept | idea, notion, thought | Latinate, front-parlor |
| data | facts, statistics, observations | Plural; means "givens" in Latin |
| function | role | When meaning "role" |
| situation | position, condition | Choose based on meaning |
| individuals | people | Plain is better |
| agents | people | The same |
| structure | (often nothing) | Usually meaningless |
| process | (delete with "the") | "transition process" → "transition" |
| the existence of X | X | Just name it |
| time frame | time | Engineering jargon |
| the turn of the nineteenth century | 1800 (or 1900) | Forces reader to puzzle |

### Pretentious Verbs to Avoid

| Avoid | Use Instead | Notes |
|-------|-------------|-------|
| critique | criticize, comment on | Elegant variation |
| implement | (Washingtonese) | Bureaucratic |
| comprise | include, consist of | Fancy talk |
| analyze | discuss, examine | Overused; means "cut to pieces" |
| hypothesize | suppose, expect | Marks you as barbarian |
| finalize | finish, complete | Boardroom talk |
| state | say, assert, argue | Overused for mere "say" |
| try and | try to | US marker of incompetence |

### Pointless Modifiers

| Avoid | Problem |
|-------|---------|
| former/latter | Requires looking back |
| the above, the preceding | Same problem |
| aforementioned | Legal-document style |
| intra/inter | Use within/between |
| interesting | Weak; sarcastic associations |
| kind of, sort of, type of | Vague |
| fortunately, interestingly | Cheap opinion injection |
| respectively | Distribute numbers directly |
| very | Most things aren't very |
| for convenience | All writing should be convenient |

### Traffic Signal Words

| Avoid | Problem |
|-------|---------|
| due to | Mysterious avoidance of "because" |
| in terms of | Same as "due to" |
| thus, hence | Use sparingly |
| plus (as "and") | Wait a century |

## Ersatz Economics Vocabulary

The person-in-the-street's economic vocabulary that no professional should use unironically:

### Price Language
- skyrocketing (have you seen a skyrocket?)
- exorbitant, gouging
- fair, just
- unfair, cutthroat
- dumping

### Power Language
- bargaining power
- exploit
- vicious cycle, spiral
- obscene profits, unwarranted margins
- unfair competition

### Needs Language
- afford ("can barely afford")
- basic necessity
- living wage
- cheap foreign labor
- priorities
- rebuilding our industrial base

These locutions embody popular misunderstanding of economics. To write thoughtfully, clear your mind of such cant.

## Teutonism Examples

### Before and After

| Knotted (Hard to Parse) | Untied (Clear) |
|------------------------|----------------|
| factor price equalization | equalization of the prices of factors |
| long-run balance of payments adjustment | adjustment of the balance of payments in the long run |
| private wealth-seeking activity | the seeking of wealth |
| elastic credit supply expectations | expectations about the supply of elastic credit |
| anti-quantity theory evidence | evidence against the quantity theory |
| contractually uniform transaction cost | the cost of transactions that are contractually uniform |
| initial relative capital goods price shock | the initial shock to the relative price of capital goods |
| community decision making process | how the community makes decisions |
| Cobb-Douglas production function estimation approach | the approach to estimating a Cobb-Douglas production function |

### The Possessive as Teutonism Generator

Avoid: "the standard political scientist's model"
Problem: Is the model standard, or the political scientist?

Use specific referents: "the model that political scientists standardly use"

## Concreteness Examples

### Economics Examples

| Abstract | Concrete |
|----------|----------|
| capital and labor embodied the same technology | machines and men embodied the same knowledge of how to spin cotton or move cargo |
| the larger numbers of spindles and ships | (already concrete) |
| natural resource-oriented exports | sheep and wheat |
| the commencement of the Spanish Price Revolution antedated the inflow of treasure | Spanish prices began to rise before the treasure came |
| growing structural differentiation | new jobs in manufacturing |
| integrative consequences of structural differentiation | the need for others that someone feels when he buys rather than bakes his bread |

### The Principle

A reader finds it harder to translate abstractions down into concrete examples than to translate examples up into abstract principles. Write concrete; let the reader generalize.

## Coherence Through Repetition

### The Polyptoton Pattern

Link sentences through repeated roots in different forms:
- linking → linkages
- repetition → repeating → repeat → repeated

### The Transitivity Pattern

(AB)(BC)(CD) is easy to understand.
(ABZYZ)(MNOP)(BJKL) is impossible.

Each sentence should share a word or concept with the previous one.

### What Not to Do

Avoid the Latin "not only...but also" pattern. It marks you as incompetent. Best writers never use it. English achieves coherence by repetition, not by frantic signaling.

## Source

McCloskey, Deirdre N. *Economical Writing*. 3rd ed. Chicago: University of Chicago Press, 2019.

For the complete 35 rules with full context, examples, and McCloskey's characteristic wit, consult the original text.
