---
name: x-execution
description: Provides workflows and frameworks for analysing, creating, and strategising content on the X platform. Includes human-in-the-loop content creation, algorithm intelligence, and platform mechanics guidance. Use this skill when the user mentions any tasks related to the X social media platform.
---

# X Execution Skill: Master Guide

This skill provides complete workflows, frameworks, and intelligence for working with the X (Twitter) platform. It combines strategic guidance with tactical execution tools.

## What This Skill Includes

### 1. Content Creation Workflow
→ **[Creating Content: Human-in-the-Loop](workflows/creating-content.md)**

A collaborative content creation process where:
- **You** provide the core idea and strategic insight
- **AI** analyzes strategy + audience to generate resonance hypotheses
- **AI** creates 10 tweet variations, each targeting a different hypothesis
- **You** review and select what to publish

**Use when:** You have a core idea and want AI help identifying angles that will resonate with your audience.

### 2. Algorithm Intelligence
→ **[Algorithm Research Section](algorithm/ALGORITHM.md)** - Start here for algorithm overview

#### Quick Navigation:
- **[Engagement Optimization](algorithm/engagement-optimization.md)** - Best practices, posting strategies, format recommendations
- **[Posting Mechanics](algorithm/posting-mechanics.md)** - How feeds work, ranking pipeline, account credibility
- **[Algorithm Trends](algorithm/algorithm-trends.md)** - Latest changes, Grok AI transition, what's coming
- **[Platform Updates](algorithm/x-platform-updates.md)** - Feature releases, policy changes, official news

**Use when:** You need to understand how X's algorithm works or optimize content for reach.

### 3. Analysis Framework
→ **[Analyzing Content Framework](workflows/analysing-content.md)**

A comprehensive framework for analyzing X content to understand:
- Psychological triggers and persuasion mechanics
- What makes content resonate with audiences
- Patterns in high-performing content

**Use when:** You're reverse-engineering successful content or want to understand what works.

### 4. Copywriting & Persuasion Analysis
→ **[Content Analysis Framework](workflows/analysing-content.md)** - Psychological triggers, persuasion mechanics, conversion patterns

A master-level framework for analyzing high-converting copy:
- Hook architecture and attention mechanisms
- Narrative frameworks and emotional arcs
- Psychological trigger identification
- Persuasion hierarchy breakdowns
- Objection handling systems
- Value communication mastery

**Use when:** You want to understand the psychology behind what makes copy convert, or reverse-engineer successful content.

### 5. Reference Materials
→ **[Analysis Frameworks](references/analysis-frameworks.md)** - Metrics frameworks, analysis models, value gap identification

---

## The X Ecosystem (October 2025)

**Current Status:** Platform in major algorithmic transition
- **Now:** Heuristic-based ranking system (being phased out)
- **Nov-Dec:** Grok AI system launching (fully AI-powered recommendations)
- **Result:** Most significant algorithm change in X history

**Key Opportunities:**
- Small accounts have unprecedented visibility opportunity
- Quality content will be rewarded independent of follower count
- Conversational feed customization coming (users will request specific topics)
- Links being reconsidered (quality content + links now viable)

**Key Challenges:**
- Expect reach volatility during transition (expected behavior)
- Some current tactics may change as AI takes over
- Niche clarity becomes critical (for new customization features)
- Algorithm details less transparent (more AI, less heuristics)

---

## Quick Start: Using This Skill

### For Content Creation
1. Have an idea or insight about something worth sharing
2. Use **[Creating Content Workflow](workflows/creating-content.md)**
3. Walk through phases: Ideation → Strategy Analysis → Hypotheses → Variations → Review
4. Select and publish variations that resonate

### For Algorithm Understanding
1. Go to **[Algorithm Overview](algorithm/ALGORITHM.md)**
2. Choose what you need:
   - **Engagement Optimization** - How to get more visibility/engagement
   - **Posting Mechanics** - How the system technically works
   - **Algorithm Trends** - What's changing and why
   - **Platform Updates** - New features and policies
3. Apply insights to your content strategy

### For Content Analysis
1. Use **[Content Analysis Framework](/workflows/analysing-content.md)**
2. Break down successful content to understand patterns
3. Extract principles for your own content

---

## Core Principles (Across All Frameworks)

### 1. Replies > Likes (By Far)
- One meaningful reply ≈ 150 likes algorithmically
- Design content to generate conversation, not just approval
- Quality of engagement matters more than quantity

### 2. Video Dominates
- 80% of user sessions include video
- Highest algorithmic prioritization
- Sweet spot: 10+ second watch time with engaging hook

### 3. Authenticity Wins
- AI can detect genuine insight vs. engagement manipulation
- Small accounts have real visibility opportunity
- Quality content will break through (new)

### 4. Audience Understanding Critical
- Know YOUR specific audience's active hours (not generic "best times")
- Understand what drives YOUR audience's engagement
- Build for your niche, not global trends

### 5. Speed Matters (First 2-3 Hours)
- First engagement signals algorithm strength
- Being online to respond quickly is important
- Early momentum = wider distribution

---

## The Three Research Domains

### Domain 1: Creating Content
**Workflow:** Human-in-the-loop ideation → strategy analysis → hypothesis generation → variation creation → human review

**Key insight:** Your human insight + AI's strategic analysis = variations that resonate

**Files:**
- [Creating Content Workflow](/workflows/creating-content.md) - Complete 5-phase process

---

### Domain 2: Understanding Algorithm
**Framework:** How X recommends content, what gets boosted/suppressed, what's changing

**Key insight:** The algorithm is shifting from heuristics to AI; preparation now = advantage later

**Files:**
- [Engagement Optimization](/algorithm/engagement-optimization.md) - Best practices
- [Posting Mechanics](/algorithm/posting-mechanics.md) - Technical explanation
- [Algorithm Trends](/algorithm/algorithm-trends.md) - What's changing
- [Platform Updates](/algorithm/x-platform-updates.md) - Official releases

---

### Domain 3: Analyzing Content
**Framework:** Psychological deconstruction of what makes content work

**Key insight:** Understanding patterns in successful content teaches principles for creation

**Files:**
- [Content Analysis Framework](/workflows/analysing-content.md) - Full framework
- [Analysis Frameworks](/references/analysis-frameworks.md) - Reference materials

---

## Key Statistics (October 2025)

| Metric | Significance |
|--------|--------------|
| Reply weight vs. like weight | +75 vs. +0.5 (replies = 150x more valuable) |
| Video in user sessions | 80% include video content |
| Optimal video length | 30-90 seconds (10+ second watch sweet spot) |
| Optimal posting frequency | 2-8 posts per day |
| Critical engagement window | First 2-3 hours after posting |
| Small account opportunity | Highest in platform history |
| Algorithm transition timeline | Complete by December 2025 |

---

## Workflow Choice Matrix

| You Want To... | Use This |
|---|---|
| Create a post from an idea | [Creating Content](/workflows/creating-content.md) |
| Understand copywriting & persuasion | [Copywriting Analysis](/workflows/analysing-content.md) |
| Reverse-engineer successful content | [Content Analysis Framework](/workflows/analysing-content.md) |
| Analyze external posts to extract patterns | [Analyzing Content](/workflows/analysing-content.md) → Apply to [Creating Content](/workflows/creating-content.md) |
| Get engagement optimization tips | [Engagement Guide](/algorithm/engagement-optimization.md) |
| Understand algorithm mechanics | [Posting Mechanics](/algorithm/posting-mechanics.md) |
| Learn what's changing | [Trends](/algorithm/algorithm-trends.md) |
| Know about new features | [Platform Updates](/algorithm/x-platform-updates.md) |
| Find analysis reference tools | [Analysis Frameworks](/references/analysis-frameworks.md) |

---

## Content Discovery & Learning Pipeline

**The Analysis-to-Creation Loop:**

1. Find high-performing posts from your market (competitors, influencers, successful creators)
2. Use [Analyzing Content](/workflows/analysing-content.md) to extract psychological triggers, structural patterns, and persuasion mechanisms
3. Analysis output is saved as a framework to `/brand/strategy/x-strategy/framework/`
4. Apply extracted patterns to [Creating Content](/workflows/creating-content.md) as informed resonance hypotheses
5. Test variations based on observed patterns, refine based on performance

**Why this matters:** Direct market observation → Pattern extraction → Data-informed content → Better resonance

---

## Integration Notes

### With Brand Strategy
The Creating Content workflow integrates with your brand strategy:
- Loads `/brand/strategy/` to understand positioning
- Loads `/brand/research/` to understand audience
- Uses both to generate resonant variations

### With Algorithm Intelligence
Algorithm research is paired with Creating Content:
- Variations are designed to be algorithmically sound
- Video and conversation generation built into variations
- Timing optimization uses algorithm insights

### With Content Analysis
Analysis framework teaches principles used in creation:
- Understand what works (analysis)
- Apply those principles (creation)
- Test and iterate (measurement)

---

## Current Context: Algorithmic Transition

**Timeline:**
- **Now (October 2025):** Heuristic system + testing
- **November-December:** Grok AI launch
- **December+:** Fully AI-powered algorithm

**What to do:**
1. Follow current best practices (they still work)
2. Prepare for customization (November launch)
3. Build niche positioning (critical for discovery)
4. Expect volatility (normal during transition)
5. Focus on fundamentals (quality, conversation, consistency)

**Resources:**
- [Algorithm Trends](/algorithm/algorithm-trends.md) - Detailed transition guide
- [Platform Updates](/algorithm/x-platform-updates.md) - Feature readiness

---

## Getting Started

### Immediate Actions
- [ ] Review [Creating Content](/workflows/creating-content.md) for next content piece
- [ ] Check [Engagement Optimization](/algorithm/engagement-optimization.md) for posting strategy
- [ ] Read [Algorithm Trends](/algorithm/algorithm-trends.md) to understand transition

### Short-term (This Month)
- [ ] Use creating-content workflow for 3-5 posts
- [ ] Track which hypotheses/variations perform best
- [ ] Monitor algorithm updates (bi-weekly via GitHub)
- [ ] Start clarifying niche positioning (prepare for Nov customization)

### Strategic (This Quarter)
- [ ] Build sustainable content engine using creating-content workflow
- [ ] Monitor Grok launch and adapt tactics
- [ ] Analyze performance data to refine hypotheses
- [ ] Prepare for conversational feed customization

---

## File Structure

```
/x-execution/
├── SKILL.md (this file)
├── /workflows/
│   ├── creating-content.md (Human-in-the-loop creation)
│   └── analysing-content.md (Content analysis framework)
├── /algorithm/
│   ├── ALGORITHM.md (Overview)
│   ├── engagement-optimization.md (Best practices)
│   ├── posting-mechanics.md (Technical details)
│   ├── algorithm-trends.md (What's changing)
│   └── x-platform-updates.md (Feature releases)
└── /references/
    └── analysis-frameworks.md (Analysis reference tools)
```

---

## Status & Version

**Last Updated:** November 14, 2025
**Skill Version:** 2.0 (Major enhancement)
**Based on:** Twitter algorithm research from October 25, 2025
**Algorithm Status:** Transitioning to Grok AI (Nov-Dec 2025)
**Next Update:** Post-Grok launch (December 2025) 

