# Target Audiences

Each batch should target multiple audiences. Understand their needs, fears, and motivations.

---

## Audience 1: Patients with Heart Disease

**Who:** Diagnosed with CAD, heart failure, AFib, post-MI, post-stent/CABG, valve disease.

**What they want:** Understand their condition, know what to expect, feel less afraid, make informed decisions, live well despite diagnosis.

**Their fears:** Another event, medication side effects, life limitations, death, being a burden.

**Content that resonates:** "Life after stenting," medication explainers, symptom interpretation, recovery timelines, outcome data.

**Tone:** Reassuring, empowering, honest without fear-mongering.

---

## Audience 2: Caregivers of Heart Patients

**Who:** Spouses, adult children, family members caring for someone with heart disease.

**What they want:** Know how to help, understand what their loved one is experiencing, recognize warning signs, support without enabling.

**Their fears:** Missing warning signs, making wrong decisions, losing loved one, caregiver burnout.

**Content that resonates:** Warning signs to watch, supporting lifestyle changes, when to call 911, caregiver self-care.

**Tone:** Supportive, practical, acknowledging emotional weight.

---

## Audience 3: Proactive Health Optimizers

**Who:** Healthy individuals (often 30-55) actively optimizing health. Follow longevity podcasts, track metrics, willing to spend on testing.

**What they want:** Evidence-based info, advanced testing recommendations (CAC, Lp(a), Apo B), optimization beyond basics, stay ahead of disease.

**Their fears:** Missing hidden risk factors, following outdated advice, "normal range" complacency.

**Content that resonates:** Advanced biomarker interpretation, emerging research, nuanced takes, optimization protocols.

**Tone:** Sophisticated, evidence-dense, respects their intelligence.

---

## Audience 4: People with Lifestyle Diseases

**Who:** Diagnosed with hypertension, Type 2 diabetes, high cholesterol, metabolic syndrome. Taking medications but may not fully understand why.

**What they want:** Understand the "why," know if they can reverse/improve, medication education, practical lifestyle modifications, hope for agency.

**Their fears:** Progression to heart disease, medications forever, feeling judged, complications.

**Content that resonates:** How lifestyle diseases connect to heart disease, what numbers mean, medication explainers, realistic lifestyle advice.

**Tone:** Non-judgmental, empowering, practical, hopeful without false promises.

---

## Audience 5: Sedentary Prevention Seekers

**Who:** Know they should be healthier. Desk jobs, limited exercise, standard diet. No diagnosis yet but worried. Often motivated by family history.

**What they want:** Know where to start, small achievable changes, understand actual risk, motivation without overwhelm.

**Their fears:** Not knowing what they don't know, sudden heart attack, having to overhaul entire life.

**Content that resonates:** Where to start guides, surprising risk factors, quick wins, screening recommendations by age.

**Tone:** Encouraging, non-overwhelming, actionable, meets them where they are.

---

## Audience Selection Per Batch

Each batch of 10 posts should include:
- At least 2 different primary audiences
- Content with crossover appeal
- Balance of sophisticated (optimizers) and accessible (prevention seekers)
