# Post Examples

Study these patterns to understand what works and what to avoid.

---

## Good Examples (Emulate These)

### Surprising Fact Opener
```
Your morning coffee might protect your heart. A meta-analysis of 36 studies found 3-5 cups daily linked to lowest CV risk. The mechanism? Likely polyphenols improving endothelial function.
```
Seeds: Coffee | Modifiers: Meta-Analysis, Mechanism | Framework: Analytical

### Myth-Busting
```
"All cholesterol is bad" is outdated thinking. LDL particle number matters more than total LDL. Two people with identical LDL-C can have vastly different cardiovascular risk.
```
Seeds: LDL, LDL-P | Modifiers: Myth-Busting, Comparison | Framework: Anthropological

### Counterintuitive Clinical Insight
```
Elevated troponin after a marathon doesn't mean heart attack. It reflects cardiac strain, not damage. Levels normalize within 24-72 hours. Context matters in biomarker interpretation.
```
Seeds: Troponin, Athletes | Modifiers: Myth-Busting, Context | Framework: Analytical

### Actionable Advice
```
Want better blood pressure control? Try 150 min/week of moderate exercise. SPRINT trial showed lifestyle modifications alone dropped systolic BP by 5-8 mmHg on average.
```
Seeds: Hypertension, Exercise | Modifiers: How-To, Research | Framework: Actionable

### Clinical Observation (Anonymized)
```
I often see patients dismiss leg swelling as "just water retention." But new ankle edema in someone with risk factors warrants cardiac evaluation. Early heart failure often hides in plain sight.
```
Seeds: Edema, Heart Failure | Modifiers: Symptoms, Early Detection | Framework: Aspirational

### Short Punchy (Under 180 chars)
```
Lp(a) is 90% genetic. Diet and exercise won't budge it. If you haven't checked yours, consider it. One test, lifelong relevance.
```
Seeds: Lp(a), Genetics | Modifiers: Prevention, Quick Summary | Framework: Analytical

### Question Hook
```
Why do heart attacks spike on Monday mornings? Cortisol surge, BP rise, and platelet aggregation peak during early AM stress. Your cardiovascular system feels that alarm clock too.
```
Seeds: MI, Circadian | Modifiers: Mechanism, Explainer | Framework: Anthropological

### Aspirational Story
```
After his stent, he walked 30 min daily. Started slow. Built up. 6 months later: off one BP med, A1c down 0.8%, 15 pounds lighter. Small consistent steps compound.
```
Seeds: PCI, Exercise | Modifiers: Post-Procedure, Aspirational | Framework: Aspirational

---

## Bad Examples (Avoid These)

### AI-Typical Phrasing ❌
```
Let's delve into the fascinating world of cardiovascular biomarkers — understanding these markers is truly a game-changer for heart health!
```
Problems: "delve," em dash, "game-changer," exclamation mark, generic.

### Overly Generic ❌
```
Studies show that exercise is good for your heart. It's important to note that staying active can help prevent heart disease.
```
Problems: "Studies show," "It's important to note," no specifics, no value.

### Overconfident Claims ❌
```
This one supplement will completely reverse your heart disease and eliminate your need for medications!
```
Problems: Overstated benefits, dangerous, not evidence-based.

### Robotic List Format ❌
```
Here are 5 ways to improve heart health:
- Exercise more
- Eat better
- Sleep well
```
Problems: Generic list format, no insight, no specifics.

### Perfect Parallel Structure ❌
```
Exercise improves your heart. Nutrition improves your heart. Sleep improves your heart.
```
Problems: Unnatural repetitive structure, obvious AI pattern.

---

## Quick Reference: Good vs Bad

| Good | Bad |
|------|-----|
| "The reason?" | "Here's the thing:" |
| "What this means:" | "Let's break it down:" |
| "Turns out," | "Interestingly," |
| "Worth knowing:" | "It's important to note that" |
| Specific numbers | Vague ("exercise more") |
| Named trials | "Studies show" |
| Contractions | Formal language |

---

## Opening Word Variety

NEVER start 2 posts with same first word. Rotate:
- Nouns: "Lp(a)...", "Heart attacks..."
- Verbs: "Want...", "Consider..."
- Questions: "Why...", "What if..."
- Numbers: "150 minutes...", "90% of..."
- Observations: "I see...", "After 20 years..."
