# Content Frameworks

Use these frameworks to structure posts and ensure variety across batches.

## The 4A Framework

Every post should fit ONE of these four paths:

### Actionable
"Here's how." Teach a specific task step-by-step.
- Best for: How-to content, protocols, practical advice
- Example: "Want better BP control? 150 min/week of moderate exercise drops systolic BP by 5-8 mmHg on average."

### Analytical  
"Here are the numbers." Use data/stats/trends to extract insights.
- Best for: Research summaries, stat-driven content, trend analysis
- Example: "Lp(a) above 50 mg/dL triples CV risk. Yet 80% of adults have never tested it."

### Aspirational
"Yes, you can." Motivate through stories showing "I did it; you can too."
- Best for: Patient stories, recovery journeys, motivation
- Example: "After his stent, my patient started walking 30 min daily. 6 months later, off 2 BP meds."

### Anthropological
"Here's why." Explain human nature/psychology behind a behavior.
- Best for: Counterintuitive insights, deeper explanations, behavioral topics
- Example: "Why do heart attacks spike Monday mornings? Cortisol surge, BP rise, and platelet aggregation peak with early alarm stress."

**Rule:** Each batch of 10 must use at least 2 different 4A frameworks.

---

## Magical Multipliers

Transform ANY topic into multiple distinct posts using these 10 angles:

| Multiplier | What It Does | Example (Topic: Lp(a)) |
|------------|--------------|------------------------|
| Tips | Actionable advice | "3 things to know if your Lp(a) is elevated" |
| Stats | Data-driven insight | "90% of Lp(a) is genetic. Diet won't change it." |
| Steps | Process breakdown | "Step 1: Test. Step 2: Calculate risk. Step 3: Discuss with doc." |
| Lessons | Wisdom from experience | "What I learned treating 500 patients with high Lp(a)" |
| Benefits | Positive outcomes | "Why testing Lp(a) once saves years of uncertainty" |
| Reasons | Justifications | "3 reasons you should know your Lp(a) before 40" |
| Mistakes | Errors to avoid | "Biggest mistake: assuming normal LDL means low risk" |
| Examples | Case studies/proof | "Patient A: normal LDL, sky-high Lp(a), 70% LAD blockage at 45" |
| Questions | FAQs, decision frameworks | "Should you test Lp(a)? Ask: family history? Early heart disease?" |
| Personal Stories | Your journey/observations | "I've seen too many 'healthy' patients blindsided. Now I test everyone." |

---

## Headline Formulas (Opening Hooks)

### 10 Proven Formats

1. **X Ways To Do Y** - "3 ways to lower blood pressure without medication"
2. **X Mistakes To Avoid** - "The mistake that makes statin side effects worse"
3. **X Lessons Learned From Y** - "What 1,000 AFib patients taught me about stroke prevention"
4. **X Tools/Tests Every [Audience] Needs** - "The one test every diabetic should ask for"
5. **How I Achieved X In Y Time** - "How my patient reversed fatty liver in 6 months"
6. **Why Everyone Gets This Wrong About X** - "Why 'good cholesterol' is more complicated than you think"
7. **The Secret To [Outcome]** - "The overlooked factor in blood pressure control: sleep"
8. **What I Wish I Knew Before X** - "What I wish patients knew before their first cath"
9. **The Framework Behind [Example]** - "How we decide statin vs no statin for borderline cases"
10. **The Surprising Truth About X** - "The surprising truth about eggs and cholesterol"

---

## Hook Patterns That Work

**Surprising Fact:** Lead with counterintuitive data.
**Myth-Busting:** Challenge common misconception.
**Question Hook:** Trigger curiosity.
**Clinical Observation:** Personal credibility (anonymized).
**Short Punchy:** Direct, memorable.
**Counterpoint:** Challenge assumption.

---

## Writing Rhythms for Skimmability

### 1/3/1 Rhythm
Short hook sentence. Three supporting sentences providing context, evidence, or examples. Short punchy conclusion.

### Varied Openings (Never Repeat)
- Direct statement: "Lp(a) levels are 90% genetic."
- Question: "Why do cardiologists care about particle number?"
- Observation: "I see this pattern repeatedly."
- Counterpoint: "But here's what most people miss."
- Number: "150 minutes per week. That's the threshold."

### Natural Transitions (Not AI-Like)
| AVOID | USE INSTEAD |
|-------|-------------|
| "Here's the thing:" | "The reason?" |
| "Let's break it down:" | "What this means:" |
| "Interestingly," | "Turns out," |
| "It's important to note that" | "Worth knowing:" |

---

## Credibility Markers

Always include when possible:
- **Study types:** RCT, meta-analysis, cohort data
- **Named trials:** SPRINT, FOURIER, REDUCE-IT, JUPITER
- **Mechanisms:** "via endothelial function," "through LDL receptor upregulation"
- **Hedging:** "suggests," "associated with," "may contribute to"
