# 6-Point Voice Check Reference

## Purpose
Before delivering ANY YouTube script, verify all 6 criteria. A single failure requires revision.

---

## The 6 Checkpoints

### 1. Authority Check

**Question:** Would Eric Topol, Peter Attia, or Andrew Huberman say this in Hinglish?

**Passing:**
- Speaks with earned confidence
- References evidence naturally
- Acknowledges uncertainty where it exists
- Never appeals to mere authority ("Because I'm a doctor...")

**Failing:**
- Hedges excessively ("Maybe possibly perhaps...")
- Overreaches without evidence
- Uses generic wellness language
- Sounds unsure or defensive

**Test:** Read aloud. Does it sound like a world-class expert teaching?

---

### 2. Domain Expert Check

**Question:** Does this sound like a cardiologist, NOT a wellness guru?

**Passing:**
- Uses precise medical terminology (explained in Hindi)
- Cites specific studies, guidelines, clinical experience
- Focuses on cardiovascular specifics
- Acknowledges limits of own expertise

**Failing:**
- Vague "heart health" platitudes
- Generic lifestyle advice without cardiac specificity
- "Toxins" and "inflammation" without specifics
- Claims expertise beyond cardiology

**Test:** Could a generic health influencer say this? If yes, add cardiac specificity.

---

### 3. Rigor Check

**Question:** Would this pass as journal review if translated to English?

**Passing:**
- Claims are evidence-based
- Citations are specific (year, journal, sample size)
- Acknowledges study limitations
- Distinguishes correlation from causation
- Presents effect sizes, not just p-values

**Failing:**
- "Studies show..." without specifics
- Cherry-picked evidence
- Oversimplified conclusions
- Ignores counter-evidence
- Presents preliminary data as settled science

**Test:** Would you cite these sources in a medical journal submission?

---

### 4. Accessibility Check

**Question:** Can a 7th grader in Delhi follow this?

**Passing:**
- Every English medical term is explained in Hindi
- Uses analogies and relatable examples
- Short, clear sentences
- Builds concepts progressively
- Uses concrete examples (patient stories)

**Failing:**
- Assumes prior medical knowledge
- Jargon without explanation
- Complex sentence structures
- Abstract concepts without grounding
- Information overload

**Test:** Read to a non-medical family member. Do they follow?

---

### 5. Non-Preachy Check

**Question:** Is this explaining, NOT sermonizing?

**Passing:**
- Presents information, respects viewer choice
- "Yeh data hai, decision aapka"
- Acknowledges lifestyle is personal
- Empowers rather than lectures
- Provides options, not mandates

**Failing:**
- "You MUST do this"
- Moral judgment on choices
- Guilt-inducing language
- "If you really cared about your health..."
- Condescending tone

**Test:** Would a patient feel respected or lectured?

---

### 6. Non-Judgmental Check

**Question:** Is this evidence-based, NOT lifestyle shaming?

**Passing:**
- Facts without moral loading
- Acknowledges systemic factors (access, cost, time)
- Focuses on what people CAN do
- Respects economic constraints
- Celebrates small wins

**Failing:**
- "If you eat this, you deserve..."
- Ignores socioeconomic reality
- Implies laziness or ignorance
- "Just stop eating [food]" as if it's simple
- Blames individuals for systemic issues

**Test:** Would someone struggling feel motivated or ashamed?

---

## Quick Reference Table

| # | Check | Core Question | Red Flags |
|---|-------|---------------|-----------|
| 1 | Authority | Topol-level expertise? | Hedging, generic claims |
| 2 | Domain Expert | Cardiologist, not guru? | Vague "wellness" talk |
| 3 | Rigor | Journal-worthy citations? | "Studies show" without detail |
| 4 | Accessibility | 7th grader follows? | Unexplained jargon |
| 5 | Non-Preachy | Explaining not sermonizing? | "You MUST..." language |
| 6 | Non-Judgmental | Evidence not shaming? | Blame-the-patient tone |

---

## Revision Protocol

If any check fails:

1. **Identify** the specific sentences/sections that fail
2. **Diagnose** which check(s) they violate
3. **Revise** targeting that specific issue
4. **Re-check** all 6 points after revision

---

## Examples

### Failing Example (Multiple violations)

> "Aapko cholesterol ke baare mein sochna chahiye. Studies show ki yeh dangerous hai. Aap agar fatty food khate ho toh aapki galti hai. Change your lifestyle!"

**Violations:**
- Check 2: Too generic ("cholesterol ke baare mein")
- Check 3: No specific studies
- Check 5: "Sochna chahiye" is preachy
- Check 6: "Aapki galti hai" is shaming

### Passing Example

> "LDL cholesterol - jisko bad cholesterol kehte hain - jab 100 mg/dL se upar jaata hai, toh arteries mein slowly jam hone lagta hai. ESC 2021 guidelines kehti hain ki high-risk patients ke liye target 55 mg/dL hona chahiye. Lekin har insaan ka situation alag hai. Aapka doctor aapki complete picture dekh ke decide karega. Mera kaam hai aapko evidence samjhana - decision aapka hai."

**Passes:**
- Check 1: Confident, specific
- Check 2: Specific cardiac mechanism
- Check 3: ESC 2021 guidelines cited
- Check 4: Explained in simple Hindi
- Check 5: "Decision aapka hai"
- Check 6: No judgment, acknowledges individual variation

---

*Apply this check to EVERY script before delivery. No exceptions.*
